	program BCDsaturation

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (nxx=7001,nyy=7001,lsize = nxx*nyy, maxvec = 99999)
        parameter (Error_factor = 0.1)
        real larray (lsize)
        real array0(nxx,nyy), BUNC (nxx,nyy)
        real array (nxx,nyy),array2(nxx,nyy),psf(nxx,nyy), gcon (nxx,nyy)
        real ScalePSF(nxx,nyy)
        real reverse(nxx,nyy),MultiPSF(nxx,nyy)
        real subtract(nxx,nyy)
        real C(9),D(9),W(9),mstars (99,3)
        real res(nxx,nyy),grid (nxx,nyy), gridraw(nxx,nyy)
        real  Rvec (maxvec),z0(maxvec),noise,model(nxx,nyy)
        real Blankit(nxx,nyy)
        real Vector (maxvec,3),rectify(nxx,nyy)
	real z(maxvec),z2(maxvec)
	real ra,dec,cd1,cd2,rot,crpix1,crpix2,exptime,fluxcon,gain
        real sdex(999),Kdex(999),SoftSat (4)
        real Pratio_thresh,Fratio_thresh
	real*8 ra8,dec8,x8,y8
        integer move(2), WCS
	integer*2 satflag(9999),mask(nxx,nyy),Zmask(nxx,nyy),flag
        integer*2 track(2,2)


	character*72 s0, s1, fBCD, fpar, fstars, Itype, fSpecial
	character*72 fBUNC, fBOUT, simage, fout
	character*72 ppth, fpsf(4), cpth
	character*72 newBCD,subBCD,logBCD,photBCD,modPixels, char, command, newRes
	character*152 PS,P1,P2,P3,P4,PC1,PC2,PC3,PC4,skypar, Rname, Sname
	character*4  Mode,Dode,vmode
	character*300000 Hfits

	real xs(999),ys(999),rs(999)

	logical doIRAC, doMIPS, doMIPS70, verbose, debug, dofull, dowrite, doclean
	logical doBUNC, erase, zexist, fail
	logical ForceR, Special, do2mass, dummy, doGcon

	verbose = .true.
	debug = .true.
	debug = .false.
	dofull = .true.
	dowrite = .true.
	doclean = .false.
	ForceR = .false.
	Special = .false.
	do2MASS = .false.
	doGcon = .false.
	dummy = .false.
	Rforce = 0.
	tweakX = 0.
        tweakY = 0.


	call getarg (1,fBCD)
	call getarg (2,s0)
	read (s0,*) x0
	call getarg (3,s0)
        read (s0,*) y0
	call getarg (4,fpar)
	call getarg (5,fstars)
	call getarg (6,Itype)

c   reserved for the radius
	s0 = ''
	call getarg (7,s0)
	L = numchar(s0)
	if (L.gt.0) then
		read (s0,*) Rforce
		ForceR = .true.
		if (Rforce.le.0.) ForceR = .false.
	endif

c reserved for convolution
	s0 = ''
	doGcon = .false.
	Rsigma = 0.
        call getarg (8,s0)
        L = numchar(s0)
	if (s0(1:L).eq.'puff') then
		doGcon = .true.
		write (6,*) 'convolve PSF:  enter gaussian sigma '
		read (5,*) Rsigma
	endif


c reserved for tweaking

	L = 0
	s0 = ''
        call getarg (9,s0)
	L = numchar(s0)

	if (L.gt.0) then
		read (s0,*) tweakX
		call getarg (10,s0)
		read (s0,*) tweakY
	endif


	doMIPS = .false.
	doMIPS70 = .false.
	doIRAC = .false.
	if (Itype(1:4).eq.'IRAC') then
		doIRAC = .true.
		doMIPS = .false.
		Mode = 'IRAC'
	else if (Itype(1:4).eq.'MIPS') then
                doIRAC = .false.
                doMIPS = .true.
		Mode = 'MIPS'
		if (Itype(1:6).eq.'MIPS70') doMIPS70 = .true.
	else if (Itype(1:4).eq.'j') then
		doIRAC = .false.
		doMIPS = .false.
		do2mass = .true.
		ib = 1
	else if (Itype(1:4).eq.'h') then
                doIRAC = .false.
                doMIPS = .false.
                do2mass = .true.
                ib = 2
	else if (Itype(1:4).eq.'k') then
                doIRAC = .false.
                doMIPS = .false.
                do2mass = .true.
                ib = 3
	endif

c	write (6,*) doIRAC, doMIPS, do2mass

c parse the parameter file

	call parsePar (fpar, doIRAC, doMIPS,  doMIPS70, do2MASS,
     1    ppth, fpsf, gfactor, cpth,
     1   Rphot, Rinner, annwidth,
     1   R_extract, SNRlim, Area_thresh,
     1   Fzone, Pratio_thresh,
     1   Fratio_thresh, RMS_thresh )

	gfactor = gfactor * 1.

	if (doIRAC) nb=4
	if (doMIPS) nb=1
	if (do2MASS) nb=3

c make sure R_extract is larger than Rphot
	rtest = Rphot * 2.

	if (R_extract.lt.rtest) then
	  R_extract = max (R_extract, rtest)
	  write (6,*) '** caution:  resizing Rextract to: ',R_extract
	endif

c	write (6,*) ' '
c	write (6,*) Rphot, Rinner, awidth
c     	write (6,*) R_extract, SNRlim, Area_thresh
c     	write (6,*) Fzone, Pratio_thresh
c     	write (6,*) Fratio_thresh, RMS_thresh

ccc load the star masking

	call loadstars (fstars,ns,xs,ys,rs)

cccccccccccccccccccccccccccccccc
c images

	simage = fBCD
        L = numchar (simage)
	fSpecial = simage(1:L)

	if (simage(L-12:L).eq.'SatFixed.fits') then
		Special = .true.
		fSpecial = simage (1:L-14) // '.fits'
	else if (simage(L-7:L).eq.'SatFixed') then
                Special = .true.
		fSpecial = simage (1:L-9)  // '.fits'
	endif

        if (simage(L-4:L).eq.'.fits') then
                M = L - 5
        else
                M = L
        endif
        simage = fBCD (1:M)
        fBUNC = fBCD (1:M-3) // 'bunc.fits'
        fBOUT = fBCD (1:M-3) // 'bunc_SatFixed.fits'

        doBUNC = .false.
        erase = .false.
        zexist = .false.
        call faccess(fBUNC,zexist,erase)
        if (zexist) then
                doBUNC = .true.
        else
                write (6,*) '** caution: uncertainty image does not exist'
        endif

	newBCD = simage(1:M) // '_SatFixed'
	if (Special) newBCD = simage(1:M)

        subBCD = simage(1:M) // '_PSFsubtracted'
c        logBCD = simage(1:M) // '.phot.log'
        photBCD = simage(1:M) // '.phot.tbl'
        modPixels = simage(1:M) // '.modpix.tbl'
        iNew = 0
        Tpass = 0

	write (6,'(a)') newBCD(1:72)


ccccccccccccccccccc

c	open (unit=47,file=modPixels)
c        write (47,'(a,a,a)') '\\ Modified pixels for original image: ',fBCD (1:M),'.fits'
c        write (47,'(a,a,a)') '\\ Modified image == ',simage(1:M) // '_SatFixed.fits'
c        write (47,'(a)') '|  i  |  j  |   original   |    modified  |'

c	open (unit=17,file=photBCD)
c        write (17,'(a,a,a)') '\\ ',fBCD(1:M),'.fits'

	call loadimage (nxx,nyy,lsize,larray,array,array0,nx,ny,
     1    ra,dec,cd1,cd2,rot,crpix1,crpix2,exptime,
     1    fluxcon,gain,ib,fBCD,MODE,verbose,do2MASS,zero, Hfits, WCS)

        if (verbose) write (6,*) ib,' MODE = ',MODE


ccccccccccccccccccc

	if ((doIRAC).or.(do2MASS)) then

	  if (doBUNC) then
           call readimage (nx,ny,lsize,larray,fBUNC,zz,zz,zz,zz,
     1      zz,zz,zz,zz,zz,zz,ii,Dode,Dummy,zz)
           ic=0
           do j=1,ny
           do i=1,nx
                BUNC(i,j) = 0.
                ic=ic+1
                BUNC(i,j) = larray(ic)
           enddo
           enddo
           if (verbose) write (6,*) 'uncertainty image loaded'
         endif

c identify the IRAC PSF images
	   
	  L = numchar(ppth)
	  if (ppth(L:L).ne.'/') then
		ppth (L+1:L+1) = '/'
		L = L+1
	  endif
 
	  LS = numchar (fpsf(1))
          p1 = ppth(1:L) // fpsf(1)(1:LS)
          LS = numchar (fpsf(2))
          p2 = ppth(1:L) // fpsf(2)(1:LS)
          LS = numchar (fpsf(3))
          p3 = ppth(1:L) // fpsf(3)(1:LS)

	  if (.not.do2MASS) then
            LS = numchar (fpsf(4))
            p4 = ppth(1:L) // fpsf(4)(1:LS)
	  endif

	else
 
c identify the MIPS psf
	  L = numchar(ppth)
	  if (ppth(L:L).ne.'/') then
                ppth (L+1:L+1) = '/'
                L = L+1
          endif
	  LS = numchar (fpsf(1))
          p1 = ppth(1:L) // fpsf(1)(1:LS)

	  if (doMIPS70) then
          	p2 = p1
	  endif

	endif
	

c now set the radial parameter in BCD units (scale = 1.22 arcsec)
        pscale = abs(cd2*3600.) ! arcsec

        Rphot = Rphot / pscale  ! pixels in BCD units
        Raper = Rphot
        Rinner = Rinner / pscale
        annwidth = annwidth / pscale
        R_extract = R_extract / pscale
c        fcon = gfactor**2   ! flux conservation
        fcon = 1.
        iphoto = 0

	do 33 KK=1,1
          if (KK.eq.1) then
             if (verbose) then
                iunit=6
             else
                goto 33
             endif
          endif
          if (KK.eq.2) iunit=15

        write (iunit,*) 'Image info: '
        write (iunit,'(2x,a,2i5,a,i2,a,f6.2,a,f7.3,a)')
     1     '[',nx,ny,'] band = ',ib,' exptime(sec) = ',
     1     exptime,' pscale = ',pscale,' arcsec per pix'
        write (iunit,'(2x,a,f9.4)') 'gain (e-/dn) = ',gain
        write (iunit,'(2x,a,f9.4)') 'fluxcon (MJy/sr/DN/s) = ',fluxcon


 33     continue

	if (fluxcon.le.0.) fluxcon = 1.
	if (gain.le.0.) gain = 1.

        pscale = pscale / 3600.  !  degrees
        pixarea = (pscale**2) / 3282.80635

ccccccccccccccccccccccc
c stats
	
	do Miter = 1,2

	if (Miter.eq.1) then
	  zl0 = -50.
          zh0 = 999.
	  if (do2MASS) zh0 = 9999.
	  if (doMIPS70) zh0 = 9999.
	else
	  zl0 = zmed - (5.*zstd)
	  zh0 = zmed + (5.*zstd)
	  zl0 = max (zl0,-50.)
	  if (doMIPS70) then
		zh0 = min (zh0,9999.)
	  else
	  	zh0 = min (zh0,999.)
	  endif
	  if (do2MASS) then
		zh0 = min (zh0,9999.)
	  endif
	endif

	ihmax = int(x0) + 300
	jhmax = int(y0) + 300
	ilmin = int(x0) - 300
	jlmin = int(y0) - 300

        il = 5
        ih = nx-5
        jl = 5
        jh = ny-5.

	ih = min (ih,ihmax)
	jh = min (jh,jhmax)

	il = max (il,ilmin)
	jl = max (jl,jlmin)

        nit = 6

	if (doMIPS70) then
		il = 1
        	ih = nx-1
        	jl = 1
        	jh = ny-1
        	nit = 25
	endif

        call stats (nxx,nyy,il,ih,jl,jh,zl0,zh0,array,nit,zmean,zstd,zmed)
        if (verbose) then
         if (miter.eq.1) write (6,*) ' '
         write (6,'(a,3f11.4,a)') 'image statistics (mean,median,RMS): ',zmean,zmed,zstd,' MJy/sr'
        endif

	enddo

c        if (verbose) write (15,'(a,3f9.4,a)') 'image statistics (mean,median,RMS): ',zmean,zmed,zstd,' MJy/sr'
        skynoise = zstd
c       gnoise = zstd / (gfactor**2)
        gnoise = skynoise
        sky = zmed

        sky_orig = sky
        skynoise_orig = skynoise

        rlorig = sky - (skynoise*4)
        rhorig = sky + (skynoise*50.)

        nx_orig = nx
        ny_orig = ny



cPPPPPPPPPPPPPPPPPPPPPPPPPPPP
c load PSF image

        if (verbose) write (6,*) ' '

        if (ib.eq.1) PS = P1
        if (ib.eq.2) PS = P2
        if (ib.eq.3) PS = P3
        if (ib.eq.4) PS = P4

c        if (verbose) write (15,'(a,a)') '  PSF image = ',PS(1:70)

        if (verbose) write (6,'(a,a)') ' loading PSF image = ',PS(1:90)
        call readimage (nxpsf,nypsf,lsize,larray,PS,rra,ddec,ccd1,ccd2,
     1    rrot,ccrpix1,ccrpix2,zz,zz,zz,izz,Dode,Dummy,zz)

        xcpsf = (nxpsf/2.0)
        ycpsf = (nypsf/2.0)

c        if (verbose) write (15,*) ' psf image size : ',nxpsf,nypsf
c        if (verbose) write (15,*) ' psf scaling factor : ',gfactor

        if (verbose) then
        write (6,*) ' psf image size : ',nxpsf,nypsf
        write (6,*) ' psf scaling factor : ',gfactor
        endif

        ic = 0
        do j=1,nypsf
        do i=1,nxpsf
          ic = ic + 1
          psf(i,j) = larray(ic)
	  gcon (i,j) = psf(i,j)
        enddo
        enddo

	if (doGcon) then

	  Rsigma = Rsigma * gfactor
	  if (Rsigma.gt.0.) then
	    write (6,*) 'guassian sigma (psf units) = ',Rsigma
            call gconvol (nxx,nyy,nxpsf,nypsf,PSF,gcon,Rsigma)

	ic = 0
	    do j=1,nypsf
            do i=1,nxpsf
              psf(i,j) = gcon(i,j)
	larray(ib) = psf(i,j)
            enddo
            enddo

c	 fout = 'gcon.fits'
c         write (6,*) 'write ',fout(1:25)
c         inax = 0
c         call writeimage (nxpsf,nypsf,larray,lsize,PS,fout,inax)

	  endif

	endif


	do j=1,nypsf
          do i=1,nxpsf
            psf(i,j) = psf(i,j) *1.e6
	    if (gfactor.gt.5) psf(i,j) = psf(i,j) * 10.
	  enddo
	enddo

cccc process source
	ip = nint(x0)
        jp = nint(y0)

	pratio = 999.
        Fratio = 999.

        xorig = x0
        yorig = y0

        ra_orig = 0.
        dec_orig = 0.

c get the max pixel
        ibox = 3
        jl = jp - ibox
        jh = jp + ibox
        il = ip - ibox
        ih = ip + ibox
        iter = 0

 452    pmax = 0.
        npmax = 0
        do j=jl,jh
        do i=il,ih
                if (array(i,j).gt.pmax) then
                        pmax = array(i,j)
                        xmax = i*1.
                        ymax = j*1.
                        npmax = npmax + 1
                        iter=iter+1
                endif
        enddo
        enddo

        ! convert to DN units
        pmax_dn = (pmax / fluxcon)*exptime

        ! convert to electrons
        pmax_e = pmax_dn * gain

        if ((npmax.eq.0).and.(iter.lt.5)) then

         jl = jl * 0.8
         jh = jh * 1.2
         il = il * 0.8
         ih = ih * 0.8
         goto 452

        endif

        if (verbose) write (6,'(1x,a,2f5.0,f8.1,a,2(f9.1,a))')
     1   ' max pixel value (x,y,value) = ',
     1    xmax,ymax,pmax,' MJy/sr  ',pmax_dn,' dn',
     1    pmax_e,'  e-'


        xorig = x0
        yorig = y0

        ra_orig = 0.
        dec_orig = 0.

c        call coord_pos (x0,y0,ra,dec,crpix1,crpix2,
c     1      rot,cd1,cd2,nx,ny,ra_orig,dec_orig)

	x8 = x0 * 1.d0
        y8 = y0 * 1.d0
        call pix2wcs (WCS, x8, y8, ra8, dec8)
        ra_orig = ra8 * 1.0
        dec_orig = dec8 * 1.0

	if (verbose) write (6,'(a,2f10.2)') 'x,y = ',xorig,yorig
        if (verbose) write (6,'(a,2f10.5)') ' ra,dec = ',ra_orig,dec_orig


c666666666666666666666666666666666666666666666666666666666666666
c local backgrounds

        Rl = Rinner
        Rh = Rl + annwidth

        xl = x0 - rh
        xh = x0 + rh
        yl = y0 - rh
        yh = y0 + rh

        vdel = 99.

        if (verbose) then
c       write (6,*) 'standard annular background geometry: ',Rl,Rh
c        write (6,*) xl,xh,yl,yh,nx,ny
        endif

        nstat = 0
        do j=int(yl),int(yh)
           dy2 = (j-y0)**2
        do 890 i=int(xl),int(xh)
           dx2 = (i-x0)**2.
           dr = sqrt (dx2+dy2)
           if (dr.lt.rl) goto 890
           if (dr.gt.rh) goto 890

           if (i.lt.1) goto 890
           if (j.lt.1) goto 890
           if (i.gt.nx) goto 890
           if (j.gt.ny) goto 890

           val = array(i,j)

           nstat = nstat + 1
           z (nstat) = val
 890    continue
        enddo

        nit = 7
        zlow = -99.
        zhigh = 9999.
        call VecStats (nstat,z,m,z2,nit,zlow,zhigh,
     1      ave,sdev,xmed)

c        if (verbose) write (6,*) nstat,m

        sky = xmed
        sky_local = sky
        if (verbose) write (6,'(1x,a,2f8.3,i7,f10.4,a,f10.4)')
     1     'local annular sky (R-,R+,N,sky,rms): ',
     1      rl,rh,m,sky,' +-',sdev


c do it again, but make the annulus further from the nuke
	Rhalfmax = nx / 2.
	
	zzz = 7.

 401    Rl = Rinner * zzz
        Rh = Rl + (annwidth*zzz/2.)

	if (Rh.gt.Rhalfmax) then
		zzz = zzz - 1.
		goto 401
	endif


	sky2 = sky_orig

        xl = x0 - rh
        xl = max (xl,1.)
        xh = x0 + rh
        xh = min (xh,nx*1.)
        yl = y0 - rh
        yl = max (yl,1.)
        yh = y0 + rh
        yh = min (yh,ny*1.)
        nstat = 0
        do j=int(yl),int(yh)
           dy2 = (j-y0)**2
        do 490 i=int(xl),int(xh)
           dx2 = (i-x0)**2.
           dr = sqrt (dx2+dy2)
           if (dr.lt.rl) goto 490
           if (dr.gt.rh) goto 490

           val = array(i,j)

	   if (nstat.lt.maxvec) then
             nstat = nstat + 1
             z (nstat) = val
	   endif
 490    continue
        enddo

        nit = 8
        zlow = -99.
        zhigh = 9999.
        call VecStats (nstat,z,m,z2,nit,zlow,zhigh,
     1      ave,sdev2,xmed)

          sky2 = xmed

         if (verbose) write (6,'(1x,a,2f8.3,i7,f10.4,a,f10.4)')
     1     'large annular sky (R-,R+,N,sky,rms): ',
     1     rl,rh,nstat,sky2,' +-',sdev2


c	if (doMIPS) sky2 = sky_local 

        skydiff = sky - sky2   ! difference between the standard annulus and the big annulus


	write (6,*) '** this is what is subtracted from the image: ',sky2


	call extract (nxx,nyy,nx,ny,array,array2,
     1      blankit,x0,y0,
     1      nnx,nny,R_extract,sky2,
     1      track)

        sky_recover = sky2

        nx = nnx
        ny = nny
        nsx = nx
        nsy = ny

        XC = (nx*1.)/2.0
        YC = (ny*1.)/2.0

        ip=nnx/2
        jp=nny/2

c        do jjj=jp-3,jp+3
c       do iii=ip-3,ip+3
c         zcheck=array2(ip,jp)
c           if (zcheck.eq.-9947.) then
c        if (verbose) write (6,*) '** REJECT due to masked pixels near star center***'
c        if (verbose) write (15,*) ' **reject due to masked pixels near star center ***'
c            Rblank = 12.
c            fail = .true.
c            goto 5001
c           endif
c        enddo
c        enddo

	ic=0
         do jj=1,ny
         do ii=1,nx
                ic=ic+1
                larray(ic)=array2(ii,jj)
                grid(ii,jj) = array2(ii,jj)
                gridraw(ii,jj) = grid(ii,jj)
                Zmask(ii,jj) = 1
                if (array2(ii,jj).le.-99) Zmask(ii,jj) = 0
         enddo
         enddo


	 fout = 'ext.fits'
         write (6,*) 'write ',fout(1:25)
         inax = 0
         call writeimage (nx,ny,larray,lsize,fBCD,fout,inax)

         if (verbose) write (6,*) ' Extracted sub-image: '
         if (verbose) write (6,*) ' 1X grid size: ',nx,ny


cc c resample onto PSF grid
c  tweak coordinates if need be

	if ((tweakX.ne.0.).or.(tweakY.ne.0.)) then
          itweak = 1
	endif

        move(1) = 0
        move(2) = 0

        call reScalePSF (nxx,nyy,nx,ny,ScalePSF,
     1     nxpsf,nypsf,psf,xcpsf,ycpsf,gfactor,move)

c        if (debug) then

       ic=0
       do jj=1,ny
       do ii=1,nx
               ic=ic+1
               larray(ic)=ScalePSF(ii,jj)
       enddo
       enddo

c	fout = 'PSForig.fits'
c      if (verbose) write (6,*) 'write ',fout(1:25)
c       call writeimage (nx,ny,larray,lsize,fBCD,fout,inax)


c        endif

        XC = (nx*1.)/2.0
        YC = (ny*1.)/2.0

c88888888888888888888888888888
c masking

        null = 0

        call maskstars (nxx,nyy,nsx,nsy,grid,
     1    ns,xs,ys,rs,x0,y0,xc,yc)

        do j=1,nsy
        do i=1,nsx
                if (grid(i,j).lt.-99.) then
                        Zmask(i,j) = 0.
                        null = 1
                endif
        enddo
        enddo

        ip = nint(xc)
        jp = nint(yc)

c mask bandwidth effects for channel 3,4

        if ((ib.gt.2).and.(.not.do2MASS)) then

          call maskbandy (nxx,nyy,nsx,nsy,grid,
     1     x0,y0,xc,yc,Zmask,null)

        endif

c        if (debug) then

          ic = 0
          do j=1,nsy
          do i=1,nsx
                ic=ic+1
                larray(ic) = grid(i,j)
          enddo
          enddo

          fout = 'check.fits'
          inax = 0
          call writeimage (nsx,nsy,larray,lsize,fBCD,fout,inax)

c        endif

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c99999999999999999999999999999999999999999999999999
c now the hard stuff, start by comparing the radials for the star and psf
c move the center around a bit, look for best fit


        Rlim = R_extract *  0.9
        Imultiple=0
        fiterror = 0.
        hsig = 0.
        fail = .false.

          call FindCenterW (fBCD,fout,nxx,nyy,maxvec,nsx,nsy,SNRlim,
     1     grid,PSF,ScalePSF,res,lsize,larray,cnx,cny,
     1     gfactor,skynoise,ib,Rlim,tweakX,tweakY,itweak,XC,YC,
     1     nxpsf,nypsf,xcpsf,ycpsf,block,iband,isat,Imultiple,
     1     Xbest,Ybest,rlbest,rhbest,ratbest,pscale,
     1     chimin,vmax,Area_thresh,MODE,fiterror,verbose,fail)


	! TEMPORARY
	ratbest = ratbest * 1.

        if (fail) then
                if (verbose) write (6,*) ' **reject -- bad fit '
                Rblank = 12.
c                 goto 5001
        endif

c statistics on the ratio image

	ic = 0

        nstat = 0
        do j=1,nsy
        do i=1,nsx
                ratio = res(i,j) / ratbest
                ic=ic+1
                larray(ic) = ratio

                if ((ratio.gt.0.).and.(ratio.lt.9.)) then
                 nstat = nstat + 1
                 z (nstat) = ratio
                endif
        enddo
        enddo

        nit = 7
        zlow = 0.
        zhigh = 5.
        call VecStats (nstat,z,m,z2,nit,zlow,zhigh,
     1      ave,sdev,xmed)

        if (verbose) then
        write (6,*) 'residual image stats'
        write (6,*) nstat,ave,sdev,xmed
        endif

        nit = 5
        vwidth = 0.02
        zlow =  xmed - (10. * sdev)
        zhigh = xmed + (10. * sdev)

        call HistStats (nstat,z,m,z2,nit,zlow,zhigh,
     1     vwidth, z50,hsig)

        if (verbose) write (6,*) 'hsig ',hsig


         hsig = min (hsig,9.9)
        fiterror = min (fiterror,9.9)

         if ((hsig.gt.RMS_thresh).and.
     1     (fiterror.gt.RMS_thresh)) then
                ! reject -- bad fit
                if (verbose) write (6,*) '** REJECT (fsig, hsig, threshold) = ',fiterror,hsig,RMS_thresh
c                if (verbose) write (15,*) ' **reject  (fsig, hsig, threshold) = ',fiterror,hsig,RMS_thresh
                Rblank = 12.
                fail = .true.
c                goto 5001
        endif



c        if (debug) then
        fout = 'res.fits'
        inax=0
        call writeimage (nsx,nsy,larray,lsize,fBCD,fout,inax)

        write (6,*) 'bestfit center ',Xbest,Ybest,rlbest,rhbest

c        endif


ccccccccccccccccccccccccc WIP
	delX = Xbest - cnx 
        delY = Ybest - cny 

	X0 = xbest
	Y0 = ybest

	if (verbose) then
	write (6,*) ' '
	write (6,*) ' position offset from target (BCD units) ',delX,delY
	write (6,*) ' '
	endif

c	if (verbose) write (15,'(a,2f10.3)') ' position offset from target (BCD units) ',delX,delY

	if ( (abs(delX).gt.10.).or.(abs(delY).gt.10) ) then
	 if (verbose) write (6,*) ' position offset from target (BCD units) ',delX,delY
	 if (verbose) write (6,*) ' **reject -- crazy position offsets; bad pixels are probably nearby'
c	 if (verbose) write (15,*) ' **reject -- crazy position offsets; bad pixels are probably nearby'
		fail = .true.
c		goto 5001
	endif

	fitcheck = (ratbest-chimin)/ratbest
	if (fitcheck.le.0.) then
c		if (verbose) write (15,*) ' **reject -- bad fit ',fitcheck
		fail = .true.
c		 goto 5001
        endif
	fitcheck = (ratbest+chimin)/ratbest
        if (fitcheck.le.0.) then
c		if (verbose) write (15,*) ' **reject -- bad fit ',fitcheck
		fail = .true.
c                 goto 5001
        endif

c	write (6,*) 'BEER ',ratbest,chimin,(ratbest-chimin)/ratbest

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c101010101010101010101010101010101010101010101010
c Recovery Time
c replace saturated pixels with model

	Rlim = rlbest * fzone

	if (ForceR) then
		Rlim = Rforce
	endif

	Replace = Rlim
	write (6,*) 'replacement radius ',Rlim
	irpass = 1

 274	Zdata = 0.
	Zrectify = 0.
	Pmax = 0.
	nc=0

	ic=0
	do j=1,nsy
                dy = j - Y0
        do 200 i=1,nsx
                dx = i - X0
                dr = sqrt ( (dx**2)+(dy**2) )

                Pval = grid (i,j)

		ic=ic+1
		larray(ic) = Pval
		subtract (i,j) = gridraw(i,j)

		Ppsf = ScalePSF (i,j)
		Ppredict = Ppsf * ratbest

c	write (6,*) i,j,ScalePSF (i,j), ratbest, Ppredict

		model (i,j) = Ppredict

		rectify (i,j) = grid (i,j)

		subtract (i,j) = gridraw (i,j) - model (i,j)

		if (dr.le.Replace) then
			 rectify (i,j) = model (i,j)
			 Zdata = grid(i,j) + Zdata
			 Zrectify = Zrectify + model (i,j)
			nc=nc+1
			Pmax = max (Pmax,Ppredict)
		else if (Zmask(i,j).le.0)  then
			rectify (i,j) = model (i,j)
		endif


 200    continue
        enddo


c	if (debug) then


	ic=0
        do j=1,nsy
        do i=1,nsx
                ic=ic+1
                larray(ic) = model(i,j)
        enddo
        enddo

        fout = 'model.fits'
	inax = 0
	call writeimage (nsx,nsy,larray,lsize,fBCD,fout,inax)

	ic=0
        do j=1,nsy
        do i=1,nsx
                ic=ic+1
                larray(ic) = rectify(i,j)
        enddo
        enddo

        fout = 'rectify.fits'
	inax = 0
	call writeimage (nsx,nsy,larray,lsize,fBCD,fout,inax)

c	endif

ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11 11
c sample back to BCD 1x scale

	sky_orig = sky_recover

	nrx = nsx
	nry = nsy
	Rreverse = Replace + 1.0

c	call grid_up (nsx,nsy,gfactor,rectify,reverse,nrx,nry,zmask,fcon,fcon2,larray)

	if (verbose) write (6,*) 'radius to replace with rectify: ',Rreverse,' BCD pixels'
	Xnom = X0
	ynom = Y0
	! find the peak

	zpeak = 0.
	do jj=int(ynom-5),nint(ynom+5)
	do ii=int(ynom-5),nint(ynom+5)
		if (rectify(ii,jj).gt.zpeak) then
		  zpeak = rectify (ii,jj)
		  xnom = ii*1.
		  ynom = jj*1.
		endif
	enddo
	enddo

	if (debug) write (6,*) 'peak pixel location ',xnom,ynom
	if (debug) write (6,*) 'track(1,2),trace(2,2) = ',track(1,2),track(2,2),ny_orig



ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 12 
c photometry using resampled image

	radius = Rphot    ! radius in bcd units
	Rad_arcsec = Rphot * pscale * 3600.  ! arc-sec

	back = skydiff   !  standard annulus vs. big annulus
	if (debug) write (6,*) 'background removed from star: ',back,' in resampled units'
        ba = 1.0
        angle= 0.
        nap= 1
        r = radius
	skysig = skynoise
	if (.not.do2MASS) zero = 20.0
	exptime = 1.0
	nc = 1

	if (debug) write (6,*) 'radius = ',r,x0,y0
        call elphot (nxx,nyy,rectify,mask,r,back,skysig,skysig,
     1     x0,y0,ba,angle,zmag,zerr,ntot,flux,zero,
     1     exptime,nc,flag)

	if (debug) write (6,*) 'rectify total counts ',ntot,flux

	if (do2MASS) then
		fluxdenR = flux
		zmagR = zero - (2.5*log10(flux))
	else
		fluxdenR = flux * pixarea * 1.e9
	endif

	if (debug) write (6,*) 'rectify ',fluxdenR,' mJy'

	r = radius
        skysig = skynoise
        if (.not.do2MASS) zero = 20.0
        exptime = 1.0
        nc = 1
        call elphot (nxx,nyy,model,mask,r,back,skysig,skysig,
     1                  x0,y0,ba,angle,zmag,zerr,ntot,flux,zero,
     1                  exptime,nc,flag)

        if (debug) write (6,*) 'model total counts ',ntot,flux

	if (do2MASS) then
                fluxdenM = flux
		zmagM = zero - (2.5*log10(flux))
        else
                fluxdenM = flux * pixarea * 1.e9
        endif

	if (debug) write (6,*) 'model ',fluxdenM,' mJy'

	r = radius
        skysig = skynoise
        if (.not.do2MASS) zero = 20.0
        exptime = 1.0
        nc = 1
        call elphot (nxx,nyy,grid,mask,r,back,skysig,skysig,
     1      x0,y0,ba,angle,zmag,zerr,ntot,flux,zero,
     1      exptime,nc,flag)

        if (debug) write (6,*) 'model total counts ',ntot,flux

	if (do2MASS) then
                fluxdenG = flux
		zmagG = zero - (2.5*log10(flux))
        else
                fluxdenG = flux * pixarea * 1.e9
        endif
        if (debug) write (6,*) 'grid ',fluxdenG,' mJy'

	pratio = Vmax / Pmax
	Fratio = fluxdenG/fluxdenR

	if ((Pratio.gt.Pratio_thresh).or.
     1     (Fratio.gt.Pratio_thresh)) then
		! reject; does not appear to be saturated
		if (verbose) write (6,*) '** REJECT (Pratio,Fratio) = ',Pratio,Fratio
c		if (verbose) write (15,*) ' **reject  (Pratio,Fratio) = ',Pratio,Fratio
		Rblank = 12.
		fail = .true.
c		goto 5001
	endif


	if ((Pratio.gt.0.5).or.
     1     (Fratio.gt.0.5)) then
		if (irpass.eq.0) then
		  irpass = 1
		  Replace = Replace * 0.75
		  goto 274
		endif
	endif


ccccccccccccccccccccccccccccccc
ccccccc   place the recovered pixels into the original BCD

	do jj = 1,ny_orig
		jdex = (jj - track(1,2)) + 1
		dy = jdex - ynom
	do ii = 1,nx_orig
		idex = (ii - track(1,1)) + 1
		dx = idex - xnom

		array (ii,jj) = array0(ii,jj) 

		if (ii.lt.track(1,1)) goto 473
		if (ii.gt.track(2,1)) goto 473
		if (jj.lt.track(1,2)) goto 473
                if (jj.gt.track(2,2)) goto 473

		dr = sqrt ( (dx**2)+(dy**2) )
		if (dr.le.Replace+1) then
		 array (ii,jj) = rectify (idex,jdex)+sky_orig
		endif

		if (.not.do2MASS) then
		  if ( (ib.eq.3).or.(ib.eq.4)) then
		  ! bandwidth removal
			XX = xnom + 4.
			YY = ynom
			ddx = idex - XX
			ddy = jdex - YY
			dr = sqrt ( (ddx**2)+(ddy**2) )
			if (dr.le.2.75) then
			  array (ii,jj) = rectify (idex,jdex)+sky_orig
			endif

			XX = xnom + 8.
                        YY = ynom
                        ddx = idex - XX
                        ddy = jdex - YY
                        dr = sqrt ( (ddx**2)+(ddy**2) )
                        if (dr.le.2.5) then
			  array (ii,jj) = rectify (idex,jdex)+sky_orig
                        endif

			XX = xnom + 13.
                        YY = ynom
                        ddx = idex - XX
                        ddy = jdex - YY
                        dr = sqrt ( (ddx**2)+(ddy**2) )
                        if (dr.le.2.5) then
			  array (ii,jj) = rectify (idex,jdex)+sky_orig
                        endif
		  endif
		endif

 473            ic=ic+1
        enddo
        enddo


	xx = xorig+delX
        yy = yorig+delY
	zz = 0.

        do jj=int(yy-2),nint(yy+2)
        do ii=int(xx-2),nint(xx+2)
                if (array(ii,jj).gt.zz) then
                  zz = array(ii,jj)
                  xp = ii*1.
                  yp = jj*1.
                endif
        enddo
        enddo

        if (debug) write (6,*) 'BCD peak pixel location ',xp,yp,zz


cccccccccccccccccccccccccccccccccc
	ranew = 0.
        decnew = 0.
c	xx = xorig+delX
c	yy = yorig+delY
	xx = xp
	yy = yp
c        call coord_pos (xx,yy,ra,dec,crpix1,crpix2,
c     1      rot,cd1,cd2,nx,ny,ranew,decnew)

	x8 = xp * 1.d0
	y8 = yp * 1.d0
	call pix2wcs (WCS, x8, y8, ra8, dec8)
	ranew = ra8 * 1.0
	decnew = dec8 * 1.0

c construct name
	Rname = ''
	write (Sname,28) ranew,'_',decnew,'_',iband
 28	format (f10.5,a,f10.5,a,i1)
	LR = numchar(Sname)

	L = 0
	do k=1,LR
		if (Sname(k:k).ne.' ') then
		 	L = L+1
			Rname(L:L) = Sname(k:k)
		endif
	enddo
	LR = numchar(Rname)

	
	if (dowrite) open (unit=70,file = Rname(1:LR) // '.tbl')
	L = numchar (simage)


c	hsig = min (hsig,9.9)
c	fiterror = min (fiterror,9.9)

c	 if ((hsig.gt.RMS_thresh).and.
c     1     (fiterror.gt.RMS_thresh)) then
c                ! reject -- bad fit
c                if (verbose) write (6,*) '** REJECT (fsig, hsig, threshold) = ',fiterror,hsig,RMS_thresh
c                write (15,*) ' **reject  (fsig, hsig, threshold) = ',fiterror,hsig,RMS_thresh
c                Rblank = 12.
c		fail = .true.
c                goto 5001
c        endif



	do 34 KK=2,2
	  if (kk.eq.1) iunit=15
	  if (kk.eq.2) iunit=70

	if (KK.eq.2) then

         write (iunit,'(a,a,a,i3)') 
     1   '\\ image = ',simage(1:L)

	 write (iunit,'(a,i3)')
     1   '\\ band = ',iband
	endif



	write (iunit,'(a)') 
     1'|  x    |  y    |    ra   |    dec  |replace|Pratio|Fratio| ferr | hsig |  loc sky|  skysig| radius|    raw   |    model   |
     1   rectify  |' 


	if (do2MASS) then
	  write (iunit,'(a)')
     1'|  -    |  -    |   deg   |    deg  | arcsec|  -   |  -   |  -   |  -   |  dn     | dn     | arcsec|    mag   |    mag     |
     1     mag    |'
	  write (iunit,'(2f8.2,2f10.5,f7.2,f8.3,f7.3,2f7.3,f10.3,f9.3,1x,f7.2,f11.3,2x,f11.3,2x,f11.3)')
     1     xorig+delX,yorig+delY,ranew,decnew,Replace*pscale*3600.,
     1     pratio,fratio,fiterror,hsig,sky_local,skynoise,
     1     Rad_arcsec,zmagG,zmagM,zmagR
	else
	  write (iunit,'(a)') 
     1'|  -    |  -    |   deg   |    deg  | arcsec|  -   |  -   |  -   |  -   |  MJy/sr | MJy/sr | arcsec|     Jy   |     Jy     |
     1     Jy     |'
	 write (iunit,'(2f8.2,2f10.5,f7.2,f8.3,f7.3,2f7.3,f10.3,f9.3,1x,f7.2,f11.2,1x,e12.5,1x,e12.5)')
     1     xorig+delX,yorig+delY,ranew,decnew,Replace*pscale*3600.,
     1     pratio,fratio,fiterror,hsig,sky_local,skynoise,
     1     Rad_arcsec,fluxdenG/1000.,fluxdenM/1000.,fluxdenR/1000.

	endif

 34	continue
	close (70)



	iunit=17
	if (Tpass.eq.0) then
	 write (iunit,'(a,i3)')
     1   '\\ band = ',iband
	write (iunit,'(a)') 
     1'|  x    |  y    |    ra   |    dec  |replace|Pratio|Fratio| ferr | hsig | loc sky| skysig| radius|    raw  |   model  |
     1  rectify |'
	write (iunit,'(a)') 
     1'|  -    |  -    |   deg   |    deg  | arcsec|  -   |  -   |  -   |  -   |  MJy/sr| MJy/sr| arcsec|    mJy  |   mJy    |
     1  mJy     |'
	    Tpass = 1
	endif

	write (iunit,'(2f8.2,2f10.5,f7.2,f8.3,f7.3,2f7.3,f9.3,f8.3,1x,f7.2,f10.2,1x,f10.2,1x,f10.2)')
     1     xorig+delX,yorig+delY,ranew,decnew,Replace*pscale*3600.,
     1     pratio,fratio,fiterror,hsig,sky_local,skynoise,
     1     Rad_arcsec,fluxdenG,fluxdenM,fluxdenR



	nfixed=nfixed + 1


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 
c wip it good

c	if (debug) then

	sky = 0.
	rl = sky2 - (skynoise*5)
	rh = log10(sky2 + (skynoise*10.))

	rl = sky - (skynoise*3.)
	if (rl.lt.0.) then
		rl = log10(skynoise/2.)
	else
		rl = log10(sky - (skynoise*5.))
	endif
	rh = log10(sky + (skynoise*10.))
	
	! check pmax
	T = pmax / 2.
	if (T.gt.skynoise*10.) then
		rh = log10(T)
	endif


	open (unit=29,file='wip.com')

	rmax_lim = rlbest * 5.
        rmax_lim = min (rmax_lim,75.)
        if (rmax_lim.gt.rhbest) rmax_lim = rhbest*1.2
        rmax_lim = max (rmax_lim,15.)

        LR = numchar(Rname)
	write (29,'(a)') Rname(1:LR)
	write (29,*)  '0 ',rmax_lim,' 0 2.5'
	write (29,*) replace

	write (29,*) rlbest,ratbest/ratbest
	write (29,*) rhbest,ratbest/ratbest
	write (29,*) rlbest,(ratbest-chimin)/ratbest
        write (29,*) rhbest,(ratbest-chimin)/ratbest
        write (29,*) rlbest,(ratbest+chimin)/ratbest
        write (29,*) rhbest,(ratbest+chimin)/ratbest


	close (29)

c	endif


c	write (71,'(a)')  Rname(1:LR) 

	if (debug) write (6,*) ' '
	command = 'cat'
	char = Rname(1:LR) // '.tbl'

	if (debug) write (6,'(a,a)') 'Photometry table: ',char(1:LR+4)
	if (verbose) call unix (command,char)
	if (debug) write (6,*) ' '


c	if (verbose) write (15,'(a,a,a)') 'table results: ',Rname(1:LR) // '.tbl'


c now copy the results back into the "original" BCD

        do jj = 1,ny_orig
        do ii = 1,nx_orig

	 vorig = array0(ii,jj)
	 vnew = array(ii,jj)
	 vunc = vnew * Error_factor

	 if (vnew.ne.vorig) then
c	  write (47,'(2i6,2x,e13.6,2x,e13.6)') ii,jj,vorig,vnew
	  if (doBUNC) BUNC (ii,jj) = vunc
	  nchange = nchange + 1
	 endif

         array0(ii,jj) = array(ii,jj)

        enddo
        enddo

c	if (verbose) write (15,*) ' '
c	if (verbose) write (15,*) nchange,'  === number of pixels modified'
c	if (verbose) write (15,*) ' '

	Rblank = rhbest  * 1.5


 5001	if (doclean) then

 	command = 'rm'
        char = 'ext.fits >& /dev/null'
        call unix (command,char)
	char = 'grid.fits >& /dev/null'
        call unix (command,char)
	char = 'model.fits >& /dev/null'
        call unix (command,char)
	char = 'rectify.fits >& /dev/null'
        call unix (command,char)
	char = 'res.fits >& /dev/null'
        call unix (command,char)

	endif
	
 881	nx = nx_orig
	ny = ny_orig

c blank the source from the mask

	rad = Rblank
	if (verbose) write (6,*) '** masking source w/radius = ',rad
        call mask_radial (nxx,nyy,nx,ny,
     1      blankit,xorig,yorig,rad)


c	if (fail) call exit(0)

c write out the residual image
	if (dowrite) then

	newRES = Rname(1:LR) // '.res.fits'
	LL = numchar (newRES)

	erase = .true.
	zexist = .false.
	call faccess(newRES,zexist,erase)

c	command = 'rm'
c        char = newRES(1:LL) // ' >& /dev/null'
c	call unix (command,char)

	ic = 0
        do j=1,nsy
        do i=1,nsx
                ic=ic+1
                larray(ic) = res(i,j) / ratbest
        enddo
        enddo

        fout = newRES
	Lf = numchar(fout)
	if (verbose) write (6,'(a,a)') 'residual image: ',fout(1:Lf)
c	if (verbose) write (15,'(a,a)') 'residual image: ',fout(1:Lf)
        inax=0
        call writeimage (nsx,nsy,larray,lsize,fBCD,fout,inax)


	endif


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW
c  write it all out

 552	if (dofull) then

	ic = 0
        do jj = 1,ny_orig
        do ii = 1,nx_orig
	 ic=ic+1
	 zval = array(ii,jj)
	 if (zval.lt.-500.) then
		zval = zval/0.   ! create NaN
	 endif
	 larray(ic) = zval
  	enddo
  	enddo

	  if (verbose) write (6,*) ' '
c	  if (verbose)  write (15,*) ' '
	  if (verbose) write (6,*) '****************************************'
	  if (verbose) write (6,*) '** writing to disk improved BCD image **'
	  L = numchar(newBCD)
	  fout = newBCD(1:L) // '.fits'
          if (verbose)  write (6,*) 'improved BCD: ',fout(1:L+5)
c	  if (verbose)  write (15,*) ' '
c	  if (verbose)  write (15,'(a,a)') 'modified BCD: ',fout(1:L+5)
	  L = numchar(photBCD)
c	  if (verbose)  write (15,'(a,a)') 'photometry: ',photBCD(1:L)
	  L = numchar(modPixels)
c	  if (verbose)  write (15,'(a,a)') 'modified pixel map: ',modPixels(1:L)
c	  L = numchar(logBCD)
c	  if (verbose)   write (15,'(a,a)') 'log: ',logBCD(1:L)
	  if (verbose) write (6,*) '****************************************'

	L = numchar(fout)
	erase = .true.
        call faccess(fout,zexist,erase)

c       command = '/usr/bin/rm -f'
c       char = fout(1:L) // ' >& /dev/null'
c       call unix (command,char)

	  inax=1
          call writeimage (nx_orig,ny_orig,larray,lsize,fSpecial,fout,inax)

c write uncertainty image

	if (doBUNC) then

	ic = 0
        do jj = 1,ny_orig
        do ii = 1,nx_orig
         ic=ic+1
         zval = BUNC(ii,jj)
         if (zval.lt.-500.) then
                zval = zval/0.   ! create NaN
         endif
         larray(ic) = zval
        enddo
        enddo

	  inax=2
          call writeimage (nx_orig,ny_orig,larray,lsize,fSpecial,fBOUT,inax)

	endif

	endif

 472	if (verbose)  then
c	 close (15)
c	 command = 'cp log'
c	 L = numchar (logBCD)
c         char = logBCD(1:L)
c        call unix (command,char)
	endif


ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	if (dowrite) then
c	  close (17)


c write the meta-table

	L1 = numchar(fBCD)
	L2 = numchar (logBCD)
	L3 = numchar (photBCD)
	L4 = numchar(newBCD)

c	write (imeta,'(i4,i6,5(1x,a))') nfixed,nchange,
c     1      fBCD(1:L1),logBCD(1:L2),photBCD(1:L3),
c     1      newBCD(1:L4)//'.fits'
c
c	close (imeta)

	endif

c 	if (verbose) write (6,*) ' '
c	if (verbose) write (6,*) 'see the log file: ',logBCD(1:L)
c	if (verbose) write (6,*) 'see the phot file: ',photBCD(1:L)


c	write (6,*) ' '
c	L = numchar(simage)
c	write (6,'(a,a,a)') 'display ',simage(1:L),'  1'
c	L = numchar(newBCD)
c        write (6,'(a,a,a)') 'display ',newBCD(1:L),'  2'

	
        call exit(0)
	end

	subroutine parsePar (fpar, doIRAC, doMIPS, doMIPS70, do2MASS,
     1   ppth, fpsf, gfactor, cpth,
     1   Rphot, Rinner, awidth,
     1   Rextract, SNRlim, Area_thresh,
     1   Fzone, Pratio_thresh,
     1   Fratio_thresh, RMS_thresh )

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) fpar, ppth, fpsf(4), cpth

	character*132 string(999),s, sval
	character*25 key,s0

	logical doIRAC, doMIPS, doMIPS70, do2MASS


	open (unit=11,file=fpar)
	n=0
	do 100 j=1,999
	 read (11,'(a)',end=99) s
	 if (s(1:1).eq.'#') goto 100
	 if (s(1:1).eq.'|') goto 100

	 L = numchar (s)
	 if (L.le.1) goto 100

	 n=n+1
	 string(n) = s
 100	continue
 99	close (11)


	 key = 'ppth'
	 M = 0
	 do j=1,n
	  S = string(j)
	  if (M.eq.0) then
		call findkey (S,key,sval)
	  	M = numchar (sval)
	  	if (M.gt.0) then
		  ppth = sval(1:M)
	  	endif
	  endif
	 enddo


	if ((doIRAC).or.(do2MASS)) then

	 key = 'gfactor_irac'
          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read (sval(1:M),*) gfactor
                endif
           endif
          enddo


	 nb = 4
	 if (do2MASS) nb=3
	 do ib=1,nb
	  if (ib.eq.1) key = 'PSF1'
	  if (ib.eq.2) key = 'PSF2'
	  if (ib.eq.3) key = 'PSF3'
	  if (ib.eq.4) key = 'PSF4'

	  M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  fpsf(ib) = sval(1:M)
                endif
           endif
          enddo
	 enddo

	endif

	if (doMIPS70) then

          key = 'gfactor_mips70'
          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read (sval(1:M),*) gfactor
                endif
           endif
          enddo


          key = 'PSF70'
          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  fpsf(1) = sval(1:M)
                endif
           endif
          enddo

	else if (doMIPS) then


	  key = 'gfactor_mips'
	  M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read (sval(1:M),*) gfactor
                endif
           endif
          enddo

	  
	  key = 'PSF24'
	  M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  fpsf(1) = sval(1:M)
                endif
           endif
          enddo

        endif




	  if ((doIRAC).or.(do2MASS)) key = 'Rphot_1'
	  if (doMIPS) key = 'Rphot_2'

          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Rphot
                endif
           endif
          enddo

	  if ((doIRAC).or.(do2MASS))  key = 'Rinner_1'
          if (doMIPS) key = 'Rinner_2'

          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Rinner
                endif
           endif
          enddo


	  if ((doIRAC).or.(do2MASS))  key = 'awidth_1'
          if (doMIPS) key = 'awidth_2'

          M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) awidth
                endif
           endif
          enddo


	key = 'Rextract'
	M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Rextract
                endif
           endif
          enddo


	key = 'SNRlim'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) SNRlim
                endif
           endif
          enddo


	key = 'Area_Thresh'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Area_Thresh
                endif
           endif
          enddo


	key = 'Fzone'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Fzone
                endif
           endif
          enddo

	key = 'Pratio_thresh'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Pratio_thresh
                endif
           endif
          enddo

	key = 'Fratio_thresh'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) Fratio_thresh
                endif
           endif
          enddo


	key = 'RMS_thresh'
        M = 0
          do j=1,n
           S = string(j)
           if (M.eq.0) then
                call findkey (S,key,sval)
                M = numchar (sval)
                if (M.gt.0) then
                  read(sval(1:M),*) RMS_thresh
                endif
           endif
          enddo


	return
	end



	subroutine findkey (S,key,sval)
	character*(*) S,key,sval
	character*25 s0

	sval = ''
	L = numchar(S)
	Lkey = numchar (key)

	I = 1
	call sfields (s,I,s0)
	M = numchar (s0)

	if (M.lt.Lkey) return
	if (M.gt.Lkey) return

	if (s0(1:M).eq.key(1:Lkey)) then

	  I = 2
          call sfields (s,I,sval)
	  return

	endif

	return
	end


c
c---- NUMCHAR ----------------------------------------------------
c
        INTEGER FUNCTION NUMCHAR(CSTRING)

C       This function determines the length of the character string
C       in cstring.

C       Author: Richard J. Stover
C       Added strong typing: D. Van Buren, T. Jarrett

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        CHARACTER*(*) CSTRING
        Integer*4     I

        IF(CSTRING .EQ. ' ') THEN
          NUMCHAR = 0
        ELSE
        DO 8701 I=LEN(CSTRING),1,-1

        IF (CSTRING(I:I) .NE. ' ' .AND. ICHAR(CSTRING(I:I)) .NE. 0)
     &        GOTO 50
        IF (ICHAR(CSTRING(I:I)) .EQ. 0) CSTRING(I:I) = ' '
 8701      CONTINUE
 50        NUMCHAR=I
         END IF

         RETURN
         END

	integer function fitchar(cstring,chr)
c 	written by T. jarrett

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	CHARACTER*(*) CSTRING,chr

	L = numchar (chr)
	ilen = numchar (cstring)

	IF(CSTRING .EQ. ' ') THEN
		fitchar = 0
	else
		do 100 i=1,ilen-(L-1)
			if (CSTRING(I:I+(L-1)).eq.chr(1:L)) then
				fitchar = i
				goto 50
			endif

 100		continue
		fitchar = 0
	endif 	

 50	return
	end

	subroutine sclean (string)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)


	CHARACTER*(*) STRING
	character*500 tmp

	L = numchar (string)

	idex = 1
	do 100 i=1,L
		if (string(i:i).ne.' ') then
			idex = i
			goto 50
		endif
 100	continue

 50	tmp(1:L) = string(1:L)
	string = ' '
	string(1:L-(idex-1)) = tmp(idex:L)

	return
	end

	real*8 function rstringcon (char)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) char

	read (char,*) rstringcon

	return
	end

	real*4 function rstrcon  (char)
	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) char
		read (char,*) rstrcon
	return
	end

	function istringcon (char)
	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) char

	read (char,*) istringcon

	return
	end

	subroutine access(char,zexist,erase)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) char
	logical erase,zexist
	character*30 command

	zexist=.false.

	inquire (file=char,exist=zexist)
	if ((zexist).and.(erase)) then
		command = '/bin/rm'
		call unix (command,char)
	endif

	return
	end

	subroutine unix(command,char)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) char,command
	character*500 result

	result = ''

	ic = numchar (command)
c	ichr = len (char)
	ic2 = numchar (char)

	do k=1,ic
		result (k:k) = command(k:k)
	enddo

	result (ic+1:ic+1)=' '
	do k=1,ic2
		result(k+ic+1:k+ic+1) = char(k:k)
	enddo

c	ii = len(result)
	ii = numchar (result)

c	write (6,'(a)') result(1:ii)
	i = system (result(1:ii))
	
	return
	end


c read string fields
	subroutine sfields (string,nf,sout)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) string,sout
	character*1 ch
	integer fields(500,2)

c assumptions: 1st field = first non-blank string

	sout = ' '

	L = NUMCHAR (string)
	n = 0

	imax = 0
	do 100 j=1,L

		if (j.le.imax) goto 100
		ch = string(j:j)
		if (ch.ne.' ') then
			imin = j
			do i=j+1,L
				ch = string(i:i)
				if (ch.eq.' ') then
					imax = i-1
					n = n + 1
					fields (n,1) = imin
					fields (n,2) = imax
					if (n.eq.nf) goto 99
					GOTO 100
				endif
			enddo
			n = n + 1
			fields (n,1) = imin
			fields (n,2) = L
			imax = L
			if (n.eq.nf) goto 99
		endif
 100	continue

	
 99	if (n.lt.nf) then
		sout = ' '
	else
		i1 = fields (nf,1)
		i2 = fields (nf,2)
		sout = string(i1:i2)
	endif


	return
	end



       subroutine header_parse (head,keyword,idex)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        character*(*) head,keyword
        character*25 s0,result,upcase

	result = upcase (keyword)
	keyword = result

c        call upcase(keyword)

        if (keyword(1:4).eq.'NULL') then
                idex=0
                return
        endif

        L = numchar (head)
        LK = numchar(keyword)


        imax = 5000
        idex = 0

        do 50 I=1,imax
                call sfields (head,I,s0)
c               call upcase(s0)
		result = upcase(s0)
		s0 = result
                LL = numchar(s0)
                if (LL.eq.0) goto 47
                if (LL.ne.LK) goto 50

                if (s0(1:LL).eq.keyword(1:LK)) then
                        idex=I
                        goto 47
                endif
 50     continue

 47     return
        end

c
c Stolen from JWF, inserted by TPC
c

c      subroutine upcase(field)
c      character*25 field
c      character*1  tmpchar
c      integer*4    i,k,lnblnk
c      byte         tmpbyte
c      equivalence (tmpbyte,tmpchar)
c      k = lnblnk(field)
c      do 10 i = 1, k
c        tmpchar = field(i:i)
c        if ((tmpbyte .gt. 96) .and. (tmpbyte .lt. 123)) then
c          tmpbyte = tmpbyte - 32
c          field(i:i) = tmpchar
c        end if
c10     continue
c       return
c       end


	function upcase(string) result(upper)
	character(len=*), intent(in) :: string
	character(len=len(string)) :: upper
	integer :: j, L

	do j = 1,len(string)
  	if(string(j:j) >= "a" .and. string(j:j) <= "z") then
       	upper(j:j) = achar(iachar(string(j:j)) - 32)
  	else
       	upper(j:j) = string(j:j)
  	end if
	end do
	end function upcase


	subroutine stringswap (string,s1,s2)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) string,s1,s2
	character*20 s0

	L = numchar(string)

	L1 = numchar(s1)
	L2 = numchar(s2)

c SNR1 >> w1snr  (4 goes to 5 chars)

	index = 0
	do 500 J = 0,L-L1
	   jl = J+1
	   jh = J+L1 
	   s0 = string(jl:jh)
	   
	   if (s0(1:L1).eq.s1(1:l1)) then
		! match

		! check neighbors
		if ((string(jl-1:jl-1).ne.' ').and.(string(jl-1:jl-1).ne.'|')) goto 500
		if ((string(jh+1:jh+1).ne.' ').and.(string(jh+1:jh+1).ne.'|')) goto 500

		il = J+1
		ih = J+L1

		if (L2.eq.L1) then

	 	   string(il:ih) = s2(1:l2)
		   write (6,*) 'ok'
		   return

		else if (L1.gt.L2) then
			write (6,'(a,a)') 'beware, string to small: ',s2(1:l2)
			return
		else if (L2.gt.L1) then
		   idiff = L2-L1
		   il2 = il - idiff
		
		   s0 = string(il2:ih)
		   call checkstring (s0,L2,igo)

		   if (igo.eq.0) then
		      write (6,'(a)')  string(il2:ih)
		      write (6,'(a)') s2(1:l2)

		      string(il2:ih) = s2(1:l2)
			write (6,*) 'ok'
		      return

		   else
			write (6,'(a,a)')  'trouble: ',s0(1:l2)

		! pad
		       string = string(1:il-1) // s2(1:l2) // string(ih+1:L)

			write (6,*) 'Add padding to format statement:  ',idiff
			write (6,*) 'ok'
		 	return
		
		   endif

		   return
		endif

	   endif
 500	continue

	return
	end

	subroutine checkstring (s0,L2,igo)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        character*(*) s0

	igo = 0
	do K=1,L2
	   if (s0(K:K).eq.'|') igo = 1
	enddo

	return
	end



c read string fields
	subroutine sfields2 (string,nf,sout, i1,i2)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) string,sout
	character*1 ch
	integer fields(500,2)

c assumptions: 1st field = first non-blank string

	sout = ' '
	i1 = 0
	i2 = 0

	L = NUMCHAR (string)
	n = 0

	imax = 0
	do 100 j=1,L

		if (j.le.imax) goto 100
		ch = string(j:j)
		if (ch.ne.' ') then
			imin = j
			do i=j+1,L
				ch = string(i:i)
				if (ch.eq.' ') then
					imax = i-1
					n = n + 1
					fields (n,1) = imin
					fields (n,2) = imax
					if (n.eq.nf) goto 99
					GOTO 100
				endif
			enddo
			n = n + 1
			fields (n,1) = imin
			fields (n,2) = L
			imax = L
			if (n.eq.nf) goto 99
		endif
 100	continue

	
 99	if (n.lt.nf) then
		sout = ' '
	else
		i1 = fields (nf,1)
		i2 = fields (nf,2)
		sout = string(i1:i2)
	endif


	return
	end


	subroutine nullswap (string,newstring)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	character*(*) string,newstring
	character*4 null

	null = 'null'

	L = numchar (string)
	newstring = string(1:L)

	if (L.lt.4) return   ! string too small to stuff NULL into

	Ndiff = L - 4

	do K=1,Ndiff
		newstring(K:K) = ' '
	enddo

	newstring(L-3:L) = null

	return
	end

	subroutine real_stringform (value, form, string, L)

	real*4 value
	character*(*) form, string
	character*25 format
	integer L, numchar

	L = numchar(form)
	format = '(' // form(1:L) // ')'
	write (string,format) value
	L = numchar (string)

	return
	end


	subroutine int_stringform (value, form, string, L)
	integer value
	character*(*) form, string
        character*25 format
        integer L, numchar

        L = numchar(form)
        format = '(' // form(1:L) // ')'
        write (string,format) value
        L = numchar (string)

        return
        end

	subroutine loadstars (fstars,ns,xs,ys, rs)
	real xs(999),ys(999),rs(999)
	character*(*) fstars

	ns=0

	open (unit=11,file=fstars)

	do j=1,999
	  read (11,*,end=99) xs(j),ys(j),rs(j)
	  ns=ns+1
	enddo
 99	close (11)

	return
	end

	subroutine faccess (char,zexist,erase)

        implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        character*(*) char
        logical erase,zexist
        character*30 command

        zexist=.false.

        inquire (file=char,exist=zexist)
        if ((zexist).and.(erase)) then
                command = '/bin/rm -f'
                call unix (command,char)
        endif

        return
        end


C *************************************************************************
	subroutine readimage (nx,ny,lsize,array,fname,ra0,dec0,
     1         cdelt1,cdelt2,crot,crpix1,crpix2,
     1           exptime,fluxcon,gain,ib,MODE,do2mass,zero)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

C  Read a FITS image and determine the minimum and maximum pixel value.
C  Rather than reading the entire image in
C  at once (which could require a very large array), the image is read
C  in pieces, 100 pixels at a time.  

      integer status,unit,readwrite,blocksize,naxes(2),nfound
      integer group,firstpix,nbuffer,npixels,i,ispitzer
      real datamin,datamax,nullval,array(lsize)
	real ra0,dec0,cdelt1,cdelt2,crot,crpix1,crpix2
	real*8 cd1a,cd1b,cd2a,cd2b,tDB,rat,angle
      logical anynull,userefined,do2mass
      character*(*) fname,MODE
	character*25 bunit,s0
      character*80 comment

	userefined = .true.   ! use refined coords if they exist
	userefined = .false.

C  The STATUS parameter must always be initialized.
      status=0

C  Get an unused Logical Unit Number to use to open the FITS file.
      call ftgiou(unit,status)

C  Open the FITS file 
      readwrite=0
      call ftopen(unit,fname,readwrite,blocksize,status)

C  Determine the size of the image.
      call ftgknj(unit,'NAXIS',1,2,naxes,nfound,status)

C  Check that it found both NAXIS1 and NAXIS2 keywords.
      if (nfound .ne. 2)then
          print *,'READIMAGE failed to read the NAXISn keywords.'
          return
       end if

	nx = naxes(1)
        ny = naxes(2)

cccc

	if (do2mass) then
		MODE = '2MASS'
		status = 0
		call ftgkys(unit, 'MAGZP', s0, comment, status)
		read (s0,*) zero
		exptime = 1.
		gain = 10.
		fluxcon = 1.

		status = 0
                call ftgkys(unit, 'FILTER', s0, comment, status)
		if (s0(1:1).eq.'j') ib=1
		if (s0(1:1).eq.'h') ib=2
		if (s0(1:1).eq.'k') ib=3

	else

	  call ftgkys(unit, 'INSTRUME', s0, comment, status)
	  MODE = s0(1:4)
          if (status.gt.0) then
                status=0
		MODE = 'IRAC'
          endif


	  ib = 0
          call ftgkyj(unit, 'CHNLNUM', ib, comment, status)
          if (status.gt.0) then
                ib=0
                status=0
          endif

	  exptime = 1.
          call ftgkye(unit, 'EXPTIME', exptime, comment, status)
          if (status.gt.0) then
                exptime = 1.
                status=0
          endif

	  fluxcon = 0.
          call ftgkye(unit, 'FLUXCONV', fluxcon, comment, status)
          if (status.gt.0) then
                fluxcon = 0.
                status=0
          endif

	  gain = 0.
          call ftgkye(unit, 'GAIN', gain, comment, status)
          if (status.gt.0) then
                gain = 0.
                status=0
          endif

	endif


	cd1_1 = -9.
        cd1_2 = -9.
        cd2_1 = -9.
        cd2_2 = -9.
        crot = 9999.
        ra = -9.
        dec = 0.

	
	ra0 = 0.
	call ftgkye(unit, 'CRVAL1', ra0, comment, status)
	if (status.gt.0) then
		ra0 = 0.
		status=0
	endif

	dec0 = 0.
        call ftgkye(unit, 'CRVAL2', dec0, comment, status)
        if (status.gt.0) then
                dec0 = 0.
                status=0
        endif
	
	crpix1=0.
	crpix2=0.
	call ftgkye(unit, 'CRPIX1', crpix1, comment, status)
        if (status.gt.0) status=0
	
	call ftgkye(unit, 'CRPIX2', crpix2, comment, status)
        if (status.gt.0) status=0

	cdelt1 = 0.
	cdelt2 = 0.
	call ftgkye(unit, 'CDELT1', cdelt1, comment, status)
        if (status.gt.0) status=0
        
        call ftgkye(unit, 'CDELT2', cdelt2, comment, status)
        if (status.gt.0) status=0

	crot=0.
	call ftgkye(unit, 'CROTA2', crot, comment, status)
        if (status.gt.0) status=0


	if ((abs(cdelt1).le.1.e-5).and.(abs(cdelt2).le.1.e-5).or.
     1     (cd2_1.lt.-5.).or.(cd2_2.lt.-5.)) then


c		write (6,*) ' looking at CD matrix'
		cd1_1=0.
		cd1_2=0.
		cd2_1=0.
		cd2_2=0.

	 call ftgkye(unit, 'CD1_1', cd1_1, comment, status)
	 status=0
	 if (userefined) then
	  tt=0.
	  call ftgkye(unit, 'CD11RFND', tt, comment, status)
          if (status.eq.0) then
c		 write (6,*) ' ** using refined coordinates'
		 cd1_1 = tt
	  endif
	 endif
	 status=0

	 call ftgkye(unit, 'CD1_2', cd1_2, comment, status)
         status=0
         if (userefined) then
          tt=0.
          call ftgkye(unit, 'CD12RFND', tt, comment, status)
          if (status.eq.0) cd1_2 = tt
         endif
         status=0	 

	 call ftgkye(unit, 'CD2_1', cd2_1, comment, status)
         status=0
         if (userefined) then
          tt=0.
          call ftgkye(unit, 'CD21RFND', tt, comment, status)
          if (status.eq.0) cd2_1 = tt
         endif
         status=0
	
	 call ftgkye(unit, 'CD2_2', cd2_2, comment, status)
         status=0
         if (userefined) then
          tt=0.
          call ftgkye(unit, 'CD22RFND', tt, comment, status)
          if (status.eq.0) cd2_2 = tt
         endif
         status=0

         if (cd2_2.ne.0.) then
                  rat = CD1_2 / CD2_2
                  angle = -datan (rat) * 57.2957795d0

		  tdb = angle/57.2957795d0

	  	  cd2a = CD2_2 / dcos(tdb)
	  	  cd2b = -CD1_2 / dsin(tdb)

		if ((abs(CD2_2).gt.abs(CD1_2))) then
                      cdelt2 = cd2a*1.
                else
                      cdelt2 = cd2b*1.
                endif

	  	  cd1a = -CD1_1 / dcos(tdb)
	  	  cd1b = -CD2_1 / dsin(tdb)

		if ((abs(CD1_1).gt.abs(CD2_1))) then
                     cdelt1 = cd1a*1.
                else
                     cdelt1 = cd1b*1.
                endif

                  crot = angle*1.

	 else if (cd1_1.ne.0.) then

		  	rat = CD2_1 / CD1_1
			angle = datan (rat) * 57.2957795d0
			tdb = angle/57.2957795d0

			cd2a = CD2_2 / dcos(tdb)
			cd2b = -CD1_2 / dsin(tdb)

			if ((abs(CD2_2).gt.abs(CD1_2))) then
			  cdelt2 = cd2a*1.
		 	else
			  cdelt2 = cd2b*1.
			endif

			cd1a = -CD1_1 / dcos(tdb)
			cd1b = -CD2_1 / dsin(tdb)
			if ((abs(CD1_1).gt.abs(CD2_1))) then
			 cdelt1 = cd1a*1.	
		        else
			 cdelt1 = cd1b*1.
			endif

			crot = angle*1.

         endif



        endif

c finally, if the refind rotation is there, use it
c	crotrefine=0.
c        call ftgkye(unit, 'CT2RFND', crotrefine, comment, status)
c        if (status.gt.0) then
c		status=0
c	else
c		write (6,*) 'changing crot from ',crot,' to ',crotrefine
c		crot = crotrefine
c	endif


C  Initialize variables
      npixels=naxes(1)*naxes(2)
      group=1
      firstpix=1
      nullval=-999
      datamin=1.0E30
      datamax=-1.0E30
      nbuffer=npixels

      call ftgpve(unit,group,firstpix,nbuffer,nullval,
     1            array,anynull,status)


C  The FITS file must always be closed before exiting the program. 
C  Any unit numbers allocated with FTGIOU must be freed with FTFIOU.
      call ftclos(unit, status)
      call ftfiou(unit, status)

       return
      end



cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
        subroutine loadimage (nxx,nyy,lsize,larray,array,array0,nx,ny,
     1     ra,dec,cd1,cd2,rot,crpix1,crpix2,exptime,fluxcon,
     1     gain,ib,fname,MODE,verbose,do2mass,zero, Hfits, WCS)

        implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        real array (nxx,nyy),array0(nxx,nyy),larray(lsize)
        real ra,dec,cd1,cd2,rot,crpix1,crpix2,exptime,fluxcon,gain
        character*(*) fname,MODE, Hfits
	integer WCS
        logical verbose,do2mass

        L = numchar(fname)
        if (fname(L-4:L).eq.'.fits') then

        else
                fname = fname(1:L) // '.fits'
        endif

        if (verbose) write (6,*) 'reading image ',fname(1:L)

	call  readFhead(fname,Hfits)
        call wcsinit(Hfits,WCS)

	zero = 20.0
	call readimage (nx,ny,lsize,larray,fname,ra,dec,cd1,cd2,
     1    rot,crpix1,crpix2,exptime,fluxcon,gain,ib,MODE,do2mass, zero)


        nx_orig = nx
        ny_orig = ny

        nbad = 0
        ic=0
        do j=1,ny
        do i=1,nx
                ic=ic+1
                array(i,j)= -998.

                if (larray(ic).ne.larray(ic)) nbad=nbad+1
                if (larray(ic).gt.-999.) then
                        array(i,j)=larray(ic)
                endif

                array0(i,j) = array(i,j)
        enddo
        enddo

        if ((nbad.gt.0).and.(verbose)) write (6,*) nbad,'  NAN pixels read'

        return
        end



      SUBROUTINE SORT(N,RA)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      DIMENSION RA(N)
      L=N/2+1
      IR=N
10    CONTINUE
        IF(L.GT.1)THEN
          L=L-1
          RRA=RA(L)
        ELSE
          RRA=RA(IR)
          RA(IR)=RA(1)
          IR=IR-1
          IF(IR.EQ.1)THEN
            RA(1)=RRA
            RETURN
          ENDIF
        ENDIF
        I=L
        J=L+L
20      IF(J.LE.IR)THEN
          IF(J.LT.IR)THEN
            IF(RA(J).LT.RA(J+1))J=J+1
          ENDIF
          IF(RRA.LT.RA(J))THEN
            RA(I)=RA(J)
            I=J
            J=J+J
          ELSE
            J=IR+1
          ENDIF
        GO TO 20
        ENDIF
        RA(I)=RRA
      GO TO 10
      END


      SUBROUTINE MOMENT(DATA,N,AVE,SDEV)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      DIMENSION DATA(N)
      real*8 s,var,p,t

      IF(N.eq.1) then
		AVE = DATA(1)
		SDEV = 0.
		goto 99
      else IF(N.Lt.1)then
		write (6,*) 'error N < 1'
		goto 99
      endif

      S=0.d0
      DO 11 J=1,N
        S=S+(DATA(J)*1.d0)
11    CONTINUE
	
      AVE=sngl(S)/N
      VAR=0.d0
      DO 12 J=1,N
        S=(DATA(J)-AVE)*1.d0
	P=S*S
        VAR=VAR+P
12    CONTINUE
      VAR=VAR/(N-1)
      t = var ** 0.5
      SDEV=sngl(t)
     
 99	i=1 
      RETURN
      END


      SUBROUTINE MDIAN1(X,N,XMED)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      DIMENSION X(N)
      
      N2=N/2
      CALL SORT(N,X)
      
      IF(2*N2.EQ.N)THEN
        XMED=0.5*(X(N2)+X(N2+1))
      ELSE
        XMED=X(N2+1)
      ENDIF


      RETURN
      END


	subroutine stats (nx,ny,il,ih,jl,jh,zl0,zh0,arr,nit,zmean,zstd,zmed)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (nz = 7001 * 7001)
	real  arr(nx,ny)
	real z(nz)

	nmin = 9

	do j=1,nit
		if (j.eq.1) then
			zl = zl0
			zh = zh0
		else
			fact = 3. 
			zl = (-fact * zstd) + zmed
			zl = max (zl,zl0)
			zh =  (fact * zstd) + zmed
			zh = min (zh,zh0)
		endif

		n = 0
		do 57  k = jl,jh
		do l = il,ih
			val = arr(l,k)
			if ( (val.ge.zl).and.(val.le.zh)) then
				 n = n + 1
				 if (n.gt.nz) n=nz
				 z(n) = val
			endif

		enddo
 57		continue

		if (n.gt.nmin) then
		  call MOMENT(z,n,zmean,zstd)
		  call MDIAN1(z,n,zmed)
		else
			zmean = -99.
			zmed = -99.
			zstd = -99.
			goto 99
		endif

c	write (6,*) j,n,zmean,zstd,zmed
  	enddo
  99 	i=1

	return
	end





c    coordinate conversion routines for ao's & coadded survey data images
c ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c	--  output from test runs are included below code  --
c
c	for questions contact: internet-	gene@ipac.caltech.edu
c				span   -	romeo::"gene%ipac" 
c				bitnet -	gene%ipac@Hamlet.Bitnet
c
c				or (818) 584-2932  
c					gene kopan  ipac
c
c -------------------------------------------------------------------------
c	test driver
c
	subroutine find (rag,decg,icrp,jcrp,crota2,cra,cdec,nz,ny,ra,dec,pz,py)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	double precision te2g(3,3),ppy,ppz,ddry,ddrz,rra,ddec,rrag,ddecg,ccrota2
	real icrp,jcrp

	dry = cdec * 60.
	drz = cra * 60.

        ppy = py * 1.d0
        ppz = pz * 1.d0
        ddry = dry * 1.d0
        ddrz = drz * 1.d0
        RRA = ra*1.0d0
        DDEC = dec *1.d0
        rrag = rag*1.d0
        ddecg = decg*1.d0
        ccrota2 = crota2 * 1.d0

	call cte2g( rrag,ddecg,ccrota2, te2g )
c	call Single_CTE2G(rag,decg,CROTA2,TE2G)

	call skytog(icrp,jcrp,ppy,ppz,ddry,ddrz,te2g,rra,ddec)
	py = sngl (ppy)
	pz = sngl (ppz)

c	call Singel_SKYTOG(PY,PZ,NY,NZ,DRY,DRZ,TE2G,ra,dec)
c	write (6,*) 'fin ',pz,py


	return
	end

c -----------------------------------------------------------------------
      SUBROUTINE Singel_GTOSKY(PY,PZ,NY,NZ,DRY,DRZ,TE2G,ALP,DEL)
C
C     GTOSKY - CONVERT PIXEL (PY,PZ) TO RA & DEC (ALP,DEL)
C
C     PY     =  Y PIXEL
C     PZ     =  Z PIXEL
C     NY     =  NUMBER OF CELLS IN Y DIRECTION
C     NZ     =  NUMBER OF CELLS IN Z DIRECTION
C     DRY    =  CELL SIZE IN Y DIRECTION (ARCMIN)
C     DRZ    =  CELL SIZE IN Z DIRECTION (ARCMIN)
C     TE2G   =  TRANSFORMATION FROM EME TO GRID COORDINATES
C     ALP    =  RIGHT ASCENSION OF PIXEL PY,PZ (DEG, EME50)
C     DEL    =  DECLINATION     OF PIXEL PY,PZ (DEG, EME50)
C

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      INTEGER NY,NZ,NYC,NZC
      REAL    ALP,DEL,PY,PZ
      DOUBLE PRECISION  TE2G(3,3),VE(3),VT(3)
      DATA RTD/57.29577951/
C                        COMPUTE GRID VECTOR
      NYC = NY/2 +1
      NZC = NZ/2 +1
      VT(2) = (PY-NYC)*DRY/(60.*RTD)
      VT(3) = (PZ-NZC)*DRZ/(60.*RTD)
      VT2   = 1.-VT(2)*VT(2)-VT(3)*VT(3)
      VT(1) = SQRT( VT2 )
C                         COMPUTE EME VECTOR AND RA,DEC
      VE(1) = TE2G(1,1)*VT(1)+TE2G(2,1)*VT(2)+TE2G(3,1)*VT(3)
      VE(2) = TE2G(1,2)*VT(1)+TE2G(2,2)*VT(2)+TE2G(3,2)*VT(3)
      VE(3) = TE2G(1,3)*VT(1)+TE2G(2,3)*VT(2)+TE2G(3,3)*VT(3)
      CDEL =  VE(2)*VE(2) + VE(3)*VE(3)
      CDEL = SQRT( CDEL )
      SDEL =  VE(1)
      DEL = RTD*ATAN2(  SDEL, CDEL  )
      SALP = -VE(2)
      CALP =  VE(3)
      ALP = RTD*ATAN2(  SALP, CALP  )
      IF( ALP .LT. 0. ) ALP = ALP + 360.
C
      RETURN
      END
C
      
      SUBROUTINE Singel_SKYTOG(PY,PZ,NY,NZ,DRY,DRZ,TE2G,ALP,DEL)
C
C      SKYTOG - CONVERT RA & DEC (ALP,DEL) TO PIXEL (PY,PZ)
C

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      INTEGER NY,NZ,NYC,NZC
      REAL    PY,PZ,ALP,DEL
      DOUBLE PRECISION  TE2G(3,3),VE(3),VT(3)
      DATA RTD/57.29577951/
C                           COMPUTE EME VECTOR
C
      NYC = NY/2 +1
      NZC = NZ/2 +1
      SDEL = SIN( sngl(DEL/ RTD*1.d0 ))
      CDEL = COS( sngl(DEL/ RTD*1.d0 ))
      SALP = SIN( sngl(ALP/ RTD*1.d0 ))
      CALP = COS( sngl(ALP/ RTD*1.d0 ))
      VE(1) = +SDEL
      VE(2) = -SALP*CDEL
      VE(3) = +CALP*CDEL
C                           COMPUTE GRID VECTOR AND PY,PZ
      VT(1) = TE2G(1,1)*VE(1)+TE2G(1,2)*VE(2)+TE2G(1,3)*VE(3)
      VT(2) = TE2G(2,1)*VE(1)+TE2G(2,2)*VE(2)+TE2G(2,3)*VE(3)
      VT(3) = TE2G(3,1)*VE(1)+TE2G(3,2)*VE(2)+TE2G(3,3)*VE(3)
      PY  = 60.*RTD*VT(2)/DRY + NYC
      PZ  = 60.*RTD*VT(3)/DRZ + NZC
C
      RETURN
      END
C
      SUBROUTINE Single_CTE2G(ALPG,DELG,CROTA2,TE2G)
C
C    COMPUTE EME50 TO GRID TRANSFORMATION
C
C     TE2G   =  TRANSFORMATION FROM EME TO GRID COORDINATES
C     ALPG   =  RIGHT ASCENSION OF GRID CENTER (DEG, EME50)
C     DELG   =  DECLINATION     OF GRID CENTER (DEG, EME50)
C     CROTA2 =  GRID ROTATION ANGLE  - FITS -  (DEG, EME50)
C
C	NOTE: TWSG IS CLOCKWISE TWIST WRT SOUTH
C

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      DOUBLE PRECISION  TE2G(3,3)
      DATA RTD/57.29577951/
C
      TWSG = CROTA2 - 180.0
      SALP = SIN( ALPG/RTD )
      CALP = COS( ALPG/RTD )
      SDEL = SIN( DELG/RTD )
      CDEL = COS( DELG/RTD )
      STWS = SIN( TWSG/RTD )
      CTWS = COS( TWSG/RTD )
      TE2G(1,1) = +SDEL
      TE2G(1,2) = -SALP*CDEL
      TE2G(1,3) = +CALP*CDEL
      TE2G(2,1) = -CDEL*CTWS
      TE2G(2,2) = -CALP*STWS -SALP*SDEL*CTWS
      TE2G(2,3) = -SALP*STWS +CALP*SDEL*CTWS
      TE2G(3,1) = +CDEL*STWS
      TE2G(3,2) = -CALP*CTWS +SALP*SDEL*STWS
      TE2G(3,3) = -SALP*CTWS -CALP*SDEL*STWS
C
      RETURN
      END

	real*8 function DEGTORAD (x)
	real*8 x

	DEGTORAD = x / 57.29577951d0

	return
	end

	real*8 function RADTODEG (x)
	real*8 x

	RADTODEG = x * 57.29577951d0

	return
	end


	subroutine coord_pos (x,y,ra,dec,icrp,jcrp,rot,cra,cdec,nx,ny,raf,decf)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)


	real icrp,jcrp

c *** note :  changed -cra to cra

	if ((raf.eq.0.).and.(decf.eq.0)) then
	  call find2 (ra,dec,icrp,jcrp,rot,cra,cdec,nx,ny,raf,decf,x,y)
	else
	  call find (ra,dec,icrp,jcrp,rot,cra,cdec,nx,ny,raf,decf,x,y)
	endif

c	  write (6,12) raf,decf,x,y
 12	  format (2f10.4,2x,2i7)


	return	
	end



c    coordinate conversion routines for ao's & coadded survey data images
c ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
c	--  output from test runs are included below code  --
c
c	for questions contact: internet-	gene@ipac.caltech.edu
c				span   -	romeo::"gene%ipac" 
c				bitnet -	gene%ipac@Hamlet.Bitnet
c
c				or (818) 584-2932  
c					gene kopan  ipac
c
c -------------------------------------------------------------------------
c	test driver
c
	subroutine find2(rag,decg,icrp,jcrp,crota2,cra,cdec,nz,ny,ra,dec,pz,py)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	double precision te2g(3,3),ppy,ppz,ddry,ddrz,rra,ddec,rrag,ddecg,ccrota2
	real icrp,jcrp

	dry = cdec * 60.
	drz = cra * 60.

	ppy = py * 1.d0
	ppz = pz * 1.d0
	ddry = dry * 1.d0
	ddrz = drz * 1.d0
	RRA = ra*1.0d0
	DDEC = dec *1.d0
	rrag = rag*1.d0
	ddecg = decg*1.d0
	ccrota2 = crota2 * 1.d0

	call cte2g( rrag,ddecg,ccrota2,te2g )

	call gtosky( icrp,jcrp,ppy,ppz,ny,nz,ddry,ddrz,te2g,rra,ddec)
	
	ra = sngl (rra)
	dec = sngl (ddec)

c     SUBROUTINE GTOSKY(icrp,jcrp,PY,PZ,NY,NZ,DRY,DRZ,TE2G,ALP,DEL)
C
c    INTEGER NY,NZ,NYC,NZC
c     real icrp,jcrp
c     DOUBLE PRECISION  ALP,DEL,PY,PZ,DRY,DRZ,RTD
c     DOUBLE PRECISION  DATAN2,VT2,SDEL,CDEL,SALP,CALP
c     DOUBLE PRECISION  TE2G(3,3),VE(3),VT(3)

		 
	return
	end


	subroutine asteqtogal (ras,decs,glong,glat)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

c -- Convert  equatorial coordinates (1950)  to galactic coordinates 
c	ras,decs in degreees

	real ras,decs,glong,glat
	real*8 lii,bii,ra,dec
	real*8 x,y,z,r,temp,drar,cosdecg,sindecg,cosdecr, degtorad, radtodeg
	real*8 LONGNCP,RAGPOLE,DECGPOLE,GEPOCH

c Definition of system: Longtitude of pole,Latitude of pole,Longitude of origin
c			Latitude of origin, Epoch of definition

	LONGNCP = 123.00d0
	RAGPOLE  = 192.25d0      
	DECGPOLE  = 27.4d0       
	GEPOCH    =  1950.0d0    

	ra = ras / 15.d0
	dec = decs * 1.d0

c Precompute the necessary constants.
	drar = DEGTORAD (15.0d0 * ra - RAGPOLE)
	cosdecg = cos (DEGTORAD (DECGPOLE))
	sindecg = sin (DEGTORAD(DECGPOLE))
	cosdecr = cos (DEGTORAD (dec))

c Compute the tansformation equations
	x = cosdecr * cos (drar)
	y =  cosdecr * sin (drar)
	z = sin (DEGTORAD (dec))
	temp = z * cosdecg - x * sindecg
	z = z * sindecg + x * cosdecg
	x = temp
        r = sqrt (x * x + y * y)
c 
c Compute lii and bii and convert to degrees.
	if (r .lt. 0.0001) then
            lii = 0.0d0
        else
            lii = DEGTORAD (LONGNCP)  + atan2 (-y, x)
	endif

        if (lii .lt. 0.0d0) lii = lii + (2. * 3.141593)

        bii = atan2 (z, r)
        lii = RADTODEG (lii)
        bii = RADTODEG (bii)

c   g187.1632+41.5656
c   d135.35+36.50

	glong = sngl(lii)
	glat = sngl(bii)

	return	
	end





c -----------------------------------------------------------------------
      SUBROUTINE GTOSKY(icrp,jcrp,PY,PZ,NY,NZ,DRY,DRZ,TE2G,ALP,DEL)

C
C     GTOSKY - CONVERT PIXEL (PY,PZ) TO RA & DEC (ALP,DEL)
C
C     PY     =  Y PIXEL
C     PZ     =  Z PIXEL
C     NY     =  NUMBER OF CELLS IN Y DIRECTION
C     NZ     =  NUMBER OF CELLS IN Z DIRECTION
C     DRY    =  CELL SIZE IN Y DIRECTION (ARCMIN)
C     DRZ    =  CELL SIZE IN Z DIRECTION (ARCMIN)
C     TE2G   =  TRANSFORMATION FROM EME TO GRID COORDINATES
C     ALP    =  RIGHT ASCENSION OF PIXEL PY,PZ (DEG, EME50)
C     DEL    =  DECLINATION     OF PIXEL PY,PZ (DEG, EME50)
C
      INTEGER NY,NZ
      real icrp,jcrp
      DOUBLE PRECISION fyc,fzc
      DOUBLE PRECISION  ALP,DEL,PY,PZ,DRY,DRZ,RTD
      DOUBLE PRECISION  DATAN2,VT2,SDEL,CDEL,SALP,CALP
      DOUBLE PRECISION  TE2G(3,3),VE(3),VT(3)
      DATA RTD/57.29577951D0/
C                        COMPUTE GRID VECTOR

C  --- better to use FZC=CRPIX1 and FYC=CRPIX2 from fits header

      FYC = jcrp*1.d0
      FZC = icrp*1.d0
      VT(2) = (PY-FYC)*DRY/(60.*RTD)
      VT(3) = (PZ-FZC)*DRZ/(60.*RTD)
      VT2   = 1.-VT(2)*VT(2)-VT(3)*VT(3)
      VT(1) = DSQRT( VT2 )
C                         COMPUTE EME VECTOR AND RA,DEC
      VE(1) = TE2G(1,1)*VT(1)+TE2G(2,1)*VT(2)+TE2G(3,1)*VT(3)
      VE(2) = TE2G(1,2)*VT(1)+TE2G(2,2)*VT(2)+TE2G(3,2)*VT(3)
      VE(3) = TE2G(1,3)*VT(1)+TE2G(2,3)*VT(2)+TE2G(3,3)*VT(3)
      CDEL =  VE(2)*VE(2) + VE(3)*VE(3)
      CDEL =  DSQRT( CDEL )
      SDEL =  VE(1)
      DEL = RTD*DATAN2(  SDEL, CDEL  )
      SALP = -VE(2)
      CALP =  VE(3)
      ALP = RTD*DATAN2(  SALP, CALP  )
      IF( ALP .LT. 0. ) ALP = ALP + 360.
C
      RETURN
      END
Ccccccccccc
ccccccccccc

      SUBROUTINE SKYTOG(icrp,jcrp,PY,PZ,DRY,DRZ,TE2G,ALP,DEL)

C
C      SKYTOG - CONVERT RA & DEC (ALP,DEL) TO PIXEL (PY,PZ)
C
      real icrp,jcrp
      DOUBLE PRECISION   ALP,DEL,PY,PZ,RTD,FYC,FZC
      DOUBLE PRECISION   SDEL,CDEL,SALP,CALP,DSIN,DCOS    
      DOUBLE PRECISION  TE2G(3,3),VE(3),VT(3),DRY,DRZ
      DATA RTD/57.29577951/
C                           COMPUTE EME VECTOR
C
C  --- better to use FZC=CRPIX1 and FYC=CRPIX2 from fits header

      FYC = jcrp*1.d0
      FZC = icrp*1.d0
      SDEL = DSIN( DEL/RTD )
      CDEL = DCOS( DEL/RTD )
      SALP = DSIN( ALP/RTD )
      CALP = DCOS( ALP/RTD )
      VE(1) = +SDEL
      VE(2) = -SALP*CDEL
      VE(3) = +CALP*CDEL
C                           COMPUTE GRID VECTOR AND PY,PZ
      VT(1) = TE2G(1,1)*VE(1)+TE2G(1,2)*VE(2)+TE2G(1,3)*VE(3)
      VT(2) = TE2G(2,1)*VE(1)+TE2G(2,2)*VE(2)+TE2G(2,3)*VE(3)
      VT(3) = TE2G(3,1)*VE(1)+TE2G(3,2)*VE(2)+TE2G(3,3)*VE(3)
      PY  = 60.d0*RTD*VT(2)/DRY + FYC
      PZ  = 60.d0*RTD*VT(3)/DRZ + FZC
C
      RETURN
      END
C
C
      SUBROUTINE CTE2G(ALPG,DELG,CROTA2,TE2G)
C
C    COMPUTE EME50 TO GRID TRANSFORMATION
C
C     TE2G   =  TRANSFORMATION FROM EME TO GRID COORDINATES
C     ALPG   =  RIGHT ASCENSION OF GRID CENTER (DEG, EME50)
C     DELG   =  DECLINATION     OF GRID CENTER (DEG, EME50)
C     CROTA2 =  GRID ROTATION ANGLE  - FITS -  (DEG, EME50)
C
C	NOTE: TWSG IS RIGHT-HANDED TWIST WRT SOUTH
C
      DOUBLE PRECISION  ALPG,DELG,CROTA2,RTD,TWSG,DSIN,DCOS
      DOUBLE PRECISION  SALP,CALP,SDEL,CDEL,STWS,CTWS
      DOUBLE PRECISION  TE2G(3,3)
      DATA RTD/57.29577951/
C
      TWSG = 180.0 + CROTA2 
      SALP = DSIN( ALPG/RTD )
      CALP = DCOS( ALPG/RTD )
      SDEL = DSIN( DELG/RTD )
      CDEL = DCOS( DELG/RTD )
      STWS = DSIN( TWSG/RTD )
      CTWS = DCOS( TWSG/RTD )
      TE2G(1,1) = +SDEL
      TE2G(1,2) = -SALP*CDEL
      TE2G(1,3) = +CALP*CDEL
      TE2G(2,1) = -CDEL*CTWS
      TE2G(2,2) = -CALP*STWS -SALP*SDEL*CTWS
      TE2G(2,3) = -SALP*STWS +CALP*SDEL*CTWS
      TE2G(3,1) = +CDEL*STWS
      TE2G(3,2) = -CALP*CTWS +SALP*SDEL*STWS
      TE2G(3,3) = -SALP*CTWS -CALP*SDEL*STWS
C
      RETURN
      END


	subroutine VecStats (n,vec,m,vout,niter,vlow,vhigh,
     1     ave,sdev,zmed)

        implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        real vec(n),vout(m)

        ave = -9999.
        sdev = -9999.
        zmed = -9999.

	vl0 = vlow
	vh0 = vhigh

	do 1000 Jit = 1,niter

        m = 0
        do 50  J = 1, n
           if (vec(J).lt.vlow) goto 50
           if (vec(J).ge.vhigh) goto 50
           m=m+1
           vout(m)=vec(J)
 50     continue

	if (m.gt.2) then
           call MOMENT(vout,m,AVE,SDEV)
           call MDIAN1(vout,m,zMED)
        else
           goto 1001
        endif

        if (Jit.eq.1) then
         vlow = zmed - (sdev * 2.)
         vhigh = zmed + (sdev * 2.)
        else
         vlow = zmed - (sdev * 3.)
         vhigh = zmed + (sdev * 3.)
        endif

	vlow = max (vlow,vl0)
	vhigh = min (vhigh, vh0)

 1000   continue

 1001   return
        end




	subroutine extract (nx,ny,nx0,ny0,array,array2,
     1     blankit,x0,y0,
     1     nsx,nsy,radius,sky,
     1     track)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	real array(7001,7001),array2(7001,7001),blankit(7001,7001)
	integer*2 track(2,2)

	I0 = nint(x0)
	J0 = nint(y0)
	ihalf = nint(radius)

	Ilow = I0 - ihalf
	Ihigh = I0 + ihalf
	Jlow = J0 - ihalf
        Jhigh = J0 + ihalf

	track(1,1) = 9999
	track(2,1) = 0
	track(1,2) = 9999
	track(2,2) = 0

	iguess = (ihigh-ilow)/2
	jguess = (jhigh-jlow)/2

	jdex = 0
	sum=0.
	do j=jlow,jhigh
		jdex=jdex+1
		idex = 0
	do i=ilow,ihigh
		idex=idex+1

		array2 (idex,jdex) = -947.

		if ( (i.gt.0).and.(i.le.nx0) ) then
			if ( (j.gt.0).and.(j.le.ny0) ) then
				value = array(i,j)
				if (value.gt.-99.) then
				  array2 (idex,jdex) = value - sky
				endif
			endif
		endif

		if (blankit(i,j).lt.0.) then
		    array2 (idex,jdex) = -947.
		    if ( (idex.eq.iguess).and.(jdex.eq.jguess) ) then
			array2 (idex,jdex) = -9947.
		    endif
		endif

		track(1,1) = min(track(1,1),i)
		track(2,1) = max(track(2,1),i)
		track(1,2) = min(track(1,2),j)
		track(2,2) = max(track(2,2),j)
		sum=sum+array2 (idex,jdex)

	enddo
	enddo
c	write (6,*) 'sum = ',sum

	nsx = idex
	nsy = jdex

	return
	end


C *************************************************************************
	subroutine writeimage (nx,ny,larray,lsize,fin,fout,inax)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)


C  Create a FITS primary array containing a 2-D image

      integer status,readwrite,inunit,outunit,blocksize,
     1   bitpix,naxis,naxes(2),nkeys,nspace
      integer existkeys
      integer i,j,group,fpixel,nelements,ncombine
      real larray(lsize)
      character*80 record,comment
      character*(*) fin,fout
      logical simple,extend

C  The STATUS parameter must be initialized before using FITSIO.  A
C  positive value of STATUS is returned whenever a serious error occurs.
C  FITSIO uses an `inherited status' convention, which means that if a
C  subroutine is called with a positive input value of STATUS, then the
C  subroutine will exit immediately, preserving the status value. For 
C  simplicity, this program only checks the status value at the end of 
C  the program, but it is usually better practice to check the status 
C  value more frequently.

      	status=0

	L = numchar(fout)
	call deletefile(fout(1:L),status)

c	write (6,*) 'delfile status ',status

	status = 0

C  Get  unused Logical Unit Numbers to use to open the FITS files.
        call ftgiou(inunit,status)
        call ftgiou(outunit,status)

c	write (6,*) 'ftgiou status ',status


C  The input FITS file is opened with READONLY access, and the output
C  FITS file is opened with WRITE access.
	readwrite=0
	blocksize=1

	L = numchar(fin)
        call ftopen(inunit,fin,readwrite,blocksize,status)

c	write (6,*) 'inunit status ',inunit,status

	status=0
c       readwrite=1
cblocksize=1
c       call ftopen(outunit,fout,readwrite,blocksize,status)


C  Create the new empty FITS file.  The blocksize parameter is a
C  historical artifact and the value is ignored by FITSIO.

      blocksize=1
      call ftinit(outunit,fout,blocksize,status)


C  This do-loop of calls to FTGREC and FTPREC copies all the keywords from
C  the input to the output FITS file.  Notice that the specified number
C  of rows in the output table, as given by the NAXIS2 keyword, will be
C  incorrect.  This value will be modified later after it is known how many
C  rows will be in the table, so it does not matter how many rows are specified
C  initially.

C  Find the number of keywords in the input table header.
	nspace=0
c	write (6,*) 'here ',inunit,nkeys,nspace,status

      call ftghsp(inunit,nkeys,nspace,status)

c	write (6,*) 'bere ',inunit,nkeys,nspace,status

      do i=1,nkeys
          call ftgrec(inunit,i,record,status)
          call ftprec(outunit,record,status)
      end do



C  Initialize parameters about the FITS image.
C  BITPIX = 16 means that the image pixels will consist of 16-bit
C  integers.  The size of the image is given by the NAXES values. 
C  The EXTEND = TRUE parameter indicates that the FITS file
C  may contain extensions following the primary array.
      simple=.true.
      bitpix=-32
      naxis=2
      naxes(1)=nx
      naxes(2)=ny
      extend=.false.

C  Write the required header keywords to the file
c      call ftphpr(outunit,simple,bitpix,naxis,naxes,0,1,extend,status)

C  Write the array to the FITS file.
C  The last letter of the subroutine name defines the datatype of the
C  array argument; in this case the 'J' indicates that the array has an
C  integer*4 datatype. ('I' = I*2, 'E' = Real*4, 'D' = Real*8).
C  The 2D array is treated as a single 1-D array with NAXIS1 * NAXIS2
C  total number of pixels.  GROUP is seldom used parameter that should
C  almost always be set = 1.
      group=1
      fpixel=1
      nelements=naxes(1)*naxes(2)
      call ftppre(outunit,group,fpixel,nelements,larray,status)


C  Write another optional keyword to the header
C  The keyword record will look like this in the FITS file:
C
C  EXPOSURE=                 1500 / Total Exposure Time
C

	if (inax.eq.0) then
	 call FTDKEY(outunit,'NAXIS1',status)
         status=0
	 call ftpkyj(outunit,'NAXIS1',nx,'array size',status)
	 status=0
	 call FTDKEY(outunit,'NAXIS2',status)
         status=0
         call ftpkyj(outunit,'NAXIS2',ny,'array size',status)
c	 write (6,*) 'testV ',nx,ny,status
	endif

	status=0
	call ftpkys(outunit,'COMMENT',
     1     'IRAC saturation-rectified BCD',
     1     'created by T.H. Jarrett (SSC/IPAC)',status)

c	write (6,*) 'test6 ',status


C  The FITS file must always be closed before exiting the program. 
C  Any unit numbers allocated with FTGIOU must be freed with FTFIOU.
	call ftclos(inunit, status)
      call ftfiou(inunit, status)
      call ftclos(outunit, status)
      call ftfiou(outunit, status)

      return
      end



C *************************************************************************
      subroutine deletefile(filename,status)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)


C  A simple little routine to delete a FITS file

      integer status,unit,blocksize,system
      character*(*) filename
	character*150 command

C  Simply return if status is greater than zero
      if (status .gt. 0) return

C  Get an unused Logical Unit Number to use to open the FITS file
      call ftgiou(unit,status)

c	write (6,*) 'inside delstatus ',status

C  Try to open the file, to see if it exists

	LL = numchar (filename)
	command = 'rm -f ' // filename(1:LL) // ' >& /dev/null'
	command = 'rm -f ' // filename(1:LL)

      call ftopen(unit,filename(1:LL),1,blocksize,status)

      if (status .eq. 0)then
C         file was opened;  so now delete it 
c          call ftdelt(unit,status)
c	  call system (command,status)
	   i = system (command)

      else if (status .eq. 103)then
C         file doesn't exist, so just reset status to zero and clear errors
          status=0
          call ftcmsg
      else
C         there was some other error opening the file; delete the file anyway
          status=0
          call ftcmsg
c          call ftdelt(unit,status)

c	write (6,'(a)') command(1:150)
c	  call system (command,status)
	  i = system (command)


      end if

C  Free the unit number for later reuse
      call ftfiou(unit, status)
      
      return
      end




****************$$$$$$$$$$$$$$$$$$$
ccc scale down the PSF to match the pixel resolution of the BCD

	subroutine reScalePSF (nxx,nyy,nx,ny,array,
     1     nxpsf,nypsf,psf,xcpsf,ycpsf,scale,move)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	real array(nxx,nyy),psf(nxx,nyy)
	integer move(2)
	
c	move(1) = 0
c	move(2) = 0

	x0 = nx * 0.5
	y0 = ny * 0.5
	
	i0 = nint(x0)
	j0 = nint(y0)

	ilow = 1
	ihigh = nx
	jlow = 1
	jhigh = ny

	is = int(scale / 2.)

c	write (6,*) scale,is
c	write (6,*) i0,j0,xcpsf,ycpsf


	do jj=jlow,jhigh
		dy = (jj-j0)*scale
		y = ycpsf + dy
		j = nint (y) + move(2)

		jl = j - is
		jl = max (j,5)
		jh = j + is
		jh = min (jh,nypsf-5)
	do ii=ilow,ihigh
		dx = (ii-i0)*scale
		x = xcpsf + dx
		i = nint (x) + move(1)

		il = i - is
		il = max (i,5)
		ih = i + is
		ih = min (ih,nxpsf-5)

		sum = 0.
		n = 0
		do j = jl,jh
		do i = il,ih
		  n=n+1
		  sum=sum+psf(i,j)
		enddo
		enddo

		if (n.gt.0) then
		 sum=sum/(n*1.)
		else
		 sum = -999.
		endif

		array (ii,jj) = sum

	enddo
	enddo

	return
	end



	subroutine FindCenterW (fname,fout,nxx,nyy,maxvec,nsx,nsy,SNRlim,
     1     grid,psf,ScalePSF,res,lsize,larray,cnx,cny,
     1     gfactor,skynoise,ib,Rlim,tweakX,tweakY,itweak,XC,YC,
     1     nxpsf,nypsf,xcpsf,ycpsf,block,iband,isat,Imultiple,
     1     Xbest,Ybest,rlbest,rhbest,ratbest,pscale,
     1     chimin,vmax,Area_thresh,MODE,error,verbose,fail)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        real psf(nxx,nyy),larray (lsize),ScalePSF(nxx,nyy)
        real res(nxx,nyy),grid (nxx,nyy)
        real  Rvec (maxvec),z0(maxvec),noise,skynoise
        real Vector (maxvec,3)
        real Zdata,z(maxvec),z2(maxvec)
	real w (99999),w2(99999)
	integer move(2),bmove(2)
	character*(*) fname,fout,MODE
	logical debug,dotweak,verbose,fail, craternot

	debug = .true.
	debug = .false.

	craternot = .false.  

	dotweak = .false.
	if (itweak.gt.0) dotweak = .true.

	chimin = 99999.
	chimin2 = 99999.
	chimin3 = 99999.
	nrbest = 5

cccc

	iband = ib

	cnx = XC
	cny = YC
	X0 = XC
	Y0 = YC

	ip0 = nint(xc)
	jp0 = nint(yc)

ccccccccccccccccccccc
c  step-1  find the crater edge

	il = nint(xc) - 5 
	ih = nint(xc) + 5 
	jl = nint(yc) - 5 
        jh = nint(yc) + 5 

	nit = 0
	ip = 0
	jp = 0

 244	zlim = skynoise * 10.     ! peak must be at least 10*sigma

	do j=jl,jh
	do i=il,ih
	  val = grid(i,j)
	  if (val.gt.zlim) then
		ip = i
		jp = j
		zlim = val
	  endif
	enddo
	enddo

	if ((ip.le.0).and.(nit.lt.10)) then
		il = il - 1
		ih = ih+1
		jl = jl-1
		jh=jh+1

		il = max (1,il)
		jl = max (1,jl)
		ih = min (nsx,ih)
		jh = min (nsy,jh)

		nit=nit+1
		goto 244
	endif

	dx = (ip - ip0) * 1.
	dy = (jp - jp0) * 1.
	dr_avoid = sqrt ( (dx**2) + (dy**2) )
	dr_avoid = dr_avoid * 1.2  ! add some padding to avoid crater edge

	if (dr_avoid.le.0.) craternot = .true.   ! no crater found; probably not saturated

	if (debug) write (6,*) 'crater rim at ',ip,jp,zlim,dr_avoid
c	if (verbose) write (15,*) 'crater rim at ',ip,jp,zlim,dr_avoid

	if ((ip.le.0).or.(jp.le.0)) then
	   ratbest = 1.
	   chimin = 999999.
	   return
	endif

c	dr_avoid = max (dr_avoid, 3.0)

c	if (dr_avoid.gt.20.) then
c                dr_avoid = 3.
c        endif


c now find where the S/N runs out;  avoid "islands"

	Rfin = Rlim

	Rstep = 1.
	Rlow = dr_avoid
	Rhigh = Rlim
	nstep = nint((Rhigh-Rlow)/Rstep)

	igood = 0

	do KKK = 1,nstep
	  Rlow = Rlow + Rstep
	  Rhigh = Rlow + Rstep
	  PI = 3.141592654
	  Area = PI * ((Rhigh**2) - (Rlow**2) )

	  n=0
	  do j=1,nsy
            dy = j - YC
	  do 110 i=1,nsx
            dx = i - XC
            dr = sqrt ( (dx**2)+(dy**2) )

            if (dr.lt.Rlow) goto 110
            if (dr.gt.Rhigh) goto 110

            Pval = grid (i,j)
            SNR = Pval / skynoise

            if (SNR.lt.SNRlim) goto 110

	    n=n+1
 110	  continue
	  enddo

	  ratio = (n*1.) / area
	  if ((ratio.gt.0.7).and.(KKK.eq.1)) igood = 1  ! demand that the fit extend beyond the inner core and be at least 50% populated
	  if ((ratio.gt.0.5).and.(KKK.eq.2)) igood = 1  ! demand that the fit extend beyond the inner core and be at least 50% populated
	  if ((ratio.gt.0.20).and.(KKK.gt.2)) igood = 1 

c	  write (6,*) KKK,Rlow,Rhigh,n,area,ratio,igood
c	  write (15,*) KKK,Rlow,Rhigh,n,area,ratio,igood

	  if ((ratio.lt.0.2).and.(igood.eq.1)) then
		Rfin = Rhigh * 1.1
		goto 111
	  endif

	enddo

c	write (6,*) 'here ',igood

	if (igood.eq.0) then
		fail = .true.
		return
	endif



cccccccccccccccccccccccccccccccccccccccccccccccc
c find the optimal center position

 111	ipass = 0
	mpass = 0
	
 	CHImin = 99999.
	CHImin2 = 99999.

	bmove(1) = 0
	bmove(2) = 0


	 ! step across +-X PSF pixels
	istep = nint(2 * gfactor)   ! depends on the scale size of the PSF


	sdevmin = 9999.
	error = 0.

	wt = 0.
        inax=0
        move(1) = 0
        move(2) = 0

	xcc=Xc
	ycc=Yc

	if (dotweak) istep = 1

        do    LITER = -istep,istep
          move(2) = LITER
          YC = Ycc - (move(2)/gfactor)
        do 47  NITER = -istep,istep
          move(1) = NITER
          XC = Xcc - (move(1)/gfactor)

	XC = xcc 
	YC = ycc

c TWEAK positions here:
	if (dotweak) then
		move(1) = tweakX
		move(2) = tweakY
	endif


	   call reScalePSF (nxx,nyy,nsx,nsy,ScalePSF,
     1      nxpsf,nypsf,psf,xcpsf,ycpsf,gfactor,move)

c  ScalePSF is now on the same pixel scale as the BCD
c  compare ScalePSF with grid

ccc process

	blow = 9999999.
	bhigh = 0.

	N=0
	vmax = 0.
	wt = 0.
	do j=1,nsy
		dy = abs(j - YC)
	do 100 i=1,nsx
		dx = i - XC
		dr = sqrt ( (dx**2)+(dy**2) )

		if (dr.lt.dr_avoid) goto 100
		if (dr.gt.Rfin) goto 100

c		if (MODE.eq.'IRAC') then
c		   if (dy.le.5) goto 100   ! avoid the muxbleed banding
c		endif

		Pval = grid (i,j)
		SNR = Pval / skynoise

		if (SNR.lt.SNRlim) then
		 if (debug) write (67,*) i,j,dr,Pval,SNR
		 goto 100
		endif

		SNR = min (SNR, 200.)

		Ppsf = ScalePSF (i,j)

		if (Ppsf.lt.1.e-8) goto 100

		ratio = Pval / Ppsf

		if (debug) then
		 if (dr.le.3) then
		   write (46,'(2i4,f8.2,2f11.5,f11.3)') i,j,dr,Pval,Ppsf, ratio
		 endif
		endif

		if (n.lt.maxvec) then
		 n=n+1
		 z0(n)= ratio
		 Rvec (n) = dr
		 w(n) = SNR**0.5
		 wt = wt + w(n)
c		 write (46,*) dr,ratio,w(n)

		 if ((ratio.gt.0.).and.(ratio.lt.blow)) then
			blow = ratio
		 endif

		 if (ratio.gt.bhigh) then
                        bhigh = ratio
                 endif

		endif

		 vmax = max (vmax,Pval)
 100	continue
	enddo

c compute the weighted mean and weighted median

	if (n.lt.3) goto 47

c	write (6,*) 'call bin_stats',Rfin,n

	bwidth = (bhigh-blow)/9000.
	bwidth = max (bwidth,1.e-4)

	call bin_stats (blow,bhigh,bwidth,z0,w,N,zmedian)

	if (debug) then

	write (6,*) blow,bhigh,bwidth
	write (6,*) n,zmedian

	endif

c	write (6,*) 'call WMOM',n
	call WMOMENT(z0,w,wt,N,AVE,SDEV)
	
        if (debug) write (6,*) ave,sdev

	rlbest = 9999
	rhbest = 0

c trim outliers
	do nit=1,10

	if (nit.le.9) then
	  zl = zmedian - (2.*sdev)
	  zh = zmedian + (2.*sdev)
	else
	  zl = zmedian - (3.*sdev)
	  zh = zmedian + (3.*sdev)
	endif

	zl = max (zl,0.)

	blow = 9999999.
	bhigh = 0.
	wt = 0
	m = 0
	do jj=1,n
	 if ((z0(jj).ge.zl).and.(z0(jj).le.zh)) then
		m=m+1
		z2(m) = z0(jj)
		w2(m) = w(jj)
		wt=wt+w2(m)

	if ((z2(m).gt.0.).and.(z2(m).lt.blow)) blow = z2(m)
	if (z2(m).gt.bhigh) bhigh  = z2(m)

		rlbest = min(Rlbest,Rvec(jj))
		rhbest = max(Rhbest,Rvec(jj))
	 endif

	enddo

c	call WMOMENT(z2,w2,wt,m,AVE,SDEV)
c	write (6,*) zl,zh,wt
c        write (6,*) nit,m,ave,sdev

        bwidth = (bhigh-blow)/9000.
        bwidth = max (bwidth,1.e-4)

        call bin_stats (blow,bhigh,bwidth,z2,w2,m,zmedian)

	call WMOMENT(z2,w2,wt,m,AVE,SDEV)

	if (debug) write (6,*) nit,n,zmedian,sdev
	enddo

	zl = zmedian - (3.*sdev)
        zh = zmedian + (3.*sdev)

	if (debug) write (6,*) zl,zh

	if (debug) write (6,'(2i3,2f8.3,i6,f12.3,f10.3)') niter,LITER,xc,yc,n,zmedian,sdev

	if (sdev.lt.sdevmin) then
	  sdevmin = sdev
	  chimin = sdev
	  ratbest = zmedian
	  bmove (1) = move(1)
	  bmove (2) = move(2)
	  xbest = xc
	  ybest = yc
	  error = sdev / zmedian

c	write (6,*) 'here ',move(1),move(2),sdev,sdevmin,ave,zmedian

	endif


 47     continue
        enddo  ! iteration


	if (debug) then
		write (6,*) 'best radial fit center: ',CHImin,xbest,ybest,x0,y0
		write (6,*) ' final best location ',CHImin,xbest,ybest,x0,y0
		write (6,*) 'best ',CHImin,ratbest
		write (6,*) xbest,ybest,ratbest,chimin
		write (6,'(2f7.2)') x0,y0
	endif


	if (debug) write (6,*) 'rlbest,rhbest ',rlbest,rhbest
	if (debug) write (6,*) 'best ',xbest,ybest,ratbest,bmove(1),bmove(2)

c	write (6,*) 'best ',xbest,ybest,ratbest,bmove(1),bmove(2)

 477	XC = xbest
	YC = ybest
	if (isat.eq.0) rlbest = 1.5

	
c remake the psf
	call reScalePSF (nxx,nyy,nsx,nsy,ScalePSF,
     1      nxpsf,nypsf,psf,xcpsf,ycpsf,gfactor,bmove)

	inax = 0

	if (debug) then

        ic=0
        do jj=1,nsy
        do ii=1,nsx
                ic=ic+1
                larray(ic)=ScalePSF(ii,jj)
        enddo
        enddo

        fout = 'rePSF.fits'
        write (6,*) 'write ',fout(1:25)
        call writeimage (nsx,nsy,larray,lsize,fname,fout,inax)

	endif


c now create output diagnostics
	N=0
        vmax = 0.

	ic = 0

	do j=1,nsy
	  dy = j - YC
         do 800 i=1,nsx

                dx = i - XC
                dr = sqrt ( (dx**2)+(dy**2) )

                res (i,j) = -999.
                Pval = grid (i,j)
                SNR = Pval / skynoise
                Ppsf = ScalePSF (i,j)

		if (dr.lt.1.) goto 800
		if (dr.gt.Rfin) goto 800
		if (SNR.lt.SNRlim) then
                 goto 800
                endif

                if (Ppsf.lt.1.e-9) goto 800

                ratio = Pval / Ppsf
		res (i,j) = ratio

c		if (debug) write (45,'(f10.3,f10.4)') dr,ratio/ratbest

		ttt = ratio/ratbest
		if (ttt.lt.99.) write (45,'(f10.3,f12.4)') dr,ttt

                if (n.lt.maxvec) then
                 n=n+1
                 z0(n)= ratio
                 Rvec (n) = dr
                endif

                vmax = max (vmax,Pval)
 800    continue
        enddo
	close (45)

	
	if (debug) write (6,*)  'final pass ',n,ratbest
	
	test_low = (ratbest-chimin)/ratbest
	test_low = min (test_low, 0.9)
	test_high = (ratbest+chimin)/ratbest
	test_high = max (test_high,1.1)

c	write (6,*) 'here ',test_low,test_high

	Rtest = rlbest
	igot = 0

	nfail = 0
	npass = 0
        Rmax = 99.
	Rmaxit = 0.
	Rmin = 1.
        Rstep = 1.
        nr = 0
	PI = 3.141592654
        do 8000 nRiter = 1,450

		Rmin = Rmin + Rstep
                Rhigh = Rmin + Rstep
                if (Rhigh.gt.Rmax) goto 8001

		Area = PI * ( (Rhigh**2) - (Rmin**2) )

                m=0
                do k=1,N
                 if ((Rvec(k).ge.Rmin).and.(Rvec(k).lt.Rhigh)) then
                       m=m+1
                       z(m)=z0(k)
                 endif
                enddo


c		Area_ratio = (m*1.)/Area
c                if (Area_ratio.lt.Area_Thresh) then
c                  nfail = nfail + 1
c                  if (npass.le.1) then
c                        goto 8000
c                  endif
c                  if ((nfail.gt.1).and.(Rmin.gt.10.)) goto 8001
c                else
c                   npass=npass+1
c                endif


                nit = 5
                vlow = -99.
                vhigh = 99999.
                call VecStats (m,z,mm,z2,nit,vlow,vhigh,
     1           ave,sdev,xmed)

		if (xmed.lt.-999.) goto 8000

                m = mm
                do k=1,mm
                        z(k)=z2(k)
                enddo

                Rave = (Rmin+Rhigh)/2.

c	write (6,*) Rave,mm,xmed,ratbest,sdev/ratbest

		eratio = xmed/ratbest

c	if (debug) then
	write (66,'(f5.1,i5,3f10.3)') 
     1    Rave,mm,ave/ratbest,sdev/ratbest,eratio
c	endif

		if (igot.eq.0) then
		 if ((eratio.gt.test_low).and.(eratio.lt.test_high)) then
			igot = 1
			Rtest = Rave
c	write (6,*) 'here ',Rave
		 endif
		endif

		if (eratio.lt.5.) Rmaxit = Rave

c                nr = nr + 1
c                Vector (nr,1) = Rave
c                Vector (nr,2) = xmed
c                Vector (nr,3) = sdev

 8000   continue

 8001	Rmaxit = Rmaxit + Rstep
	rhbest = Rmaxit
	rlbest = max(Rtest,rlbest)

	if (craternot) then  ! probably not saturated; decrease the replacement radius
	  rlbest = min (rlbest, 2.0)
	endif

c	write (6,*) 'Rtest,rlbest ',Rtest,rlbest

	return
	end



	subroutine bin_stats (blow,bhigh,bwidth,data,w,N,zmedian)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (max = 9000)
	real data(N),w(n)
	integer count (max)

	do j=1,max
		count(j) = 0
	enddo

	ntot = 0
	iff = 0
	do 50 j=1,N
		val = data(j)
		if (val.eq.-947.) iff=1
		if (val.lt.blow) goto 50
		if (val.gt.bhigh) goto 50

		dval = val - blow
		idex = 1 + int(dval / bwidth)	
		if (idex.gt.max) goto 50

		iadd = nint(w(j))
		ntot = ntot + iadd
		count(idex) = count(idex) + iadd

 50	continue

	if (ntot.lt.3) then
		zmedian = -9999.
		if (iff.eq.1) zmedian = -947.
		goto 66
	endif

	i50 = nint( (ntot*1.) / 2.0)

	isum = 0
	do j=1,max

		isum = isum + count(j)
		if (isum.eq.i50) then
			zmedian = blow + (j * bwidth) - (bwidth / 2.0)
			goto 51
		endif

		if (isum.gt.i50) then
c 		  interpolate
		  idel = isum - isum_prev
		  ilow = i50 - isum_prev
		  ratio = (ilow*1.) / (idel*1.)
		  del = bwidth * ratio

		  zmedian = (del + blow) + ((j-1) * bwidth) - (bwidth / 2.0)
		  goto 51
		endif

		isum_prev = isum
	enddo
 51 	i=1



 66	i=1

	return
	end			



      SUBROUTINE WMOMENT(DATA,w,wt,N,AVE,SDEV)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

      DIMENSION DATA(N),w(N)
      real*8 s,var,p,t

      IF(N.eq.1) then
                AVE = DATA(1)
                SDEV = 0.
                goto 99
      else IF(N.Lt.1)then
                write (6,*) 'error N < 1'
                goto 99
      endif

      S=0.d0
      DO 11 J=1,N
	wfact = w(J)/wt
        S=S+(DATA(J)*wfact*1.d0)
11    CONTINUE

      AVE0=sngl(S)/N
      AVE=sngl(S)
      VAR=0.d0
	sumw = 0.
      DO 12 J=1,N
	wfact = w(J)
        S=(DATA(J)-ave)*1.d0
        P=S*S
        VAR=VAR+(P*wfact)
	sumw = sumw + (wfact**2)
12    CONTINUE
c      VAR=VAR/(N-1)

	var = (wt/ ((wt**2)-sumw)) * var
c	var = var / (wt*1.d0)
      t = var ** 0.5
      SDEV=sngl(t)

 99     i=1
      RETURN
      END


	subroutine HistStats (n,vec,m,vout,niter,
     1     vlow,vhigh,vwidth,
     1     z50,hsig)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (max = 50000)

	real vec(n),vout(n)
	integer count (max)
	logical debug

	debug = .true.
	debug = .false.

	it = 0
 47	ztot = (vhigh - vlow) / vwidth
	it = it + 1

	if (nint(ztot).ge.max) then
c	  write (74,*) '** warning -- HistStat bin width too small ',it
	  vwidth = vwidth * 2.
	  goto 47
	endif

	ave = -9999.
        sdev = -9999.
        zmed = -9999.

	do 1000 Jit = 1,niter

	do j=1,max
                count(j) = 0
        enddo

	m = 0
	do 50  J = 1, n
	   if (vec(J).lt.vlow) goto 50
	   if (vec(J).ge.vhigh) goto 50

	   m=m+1
	   vout(m)=vec(J)

	  dval = vec(J) - vlow
          idex = 1 + int(dval / vwidth)
          if (idex.ge.max) goto 50

           count(idex) = count(idex) + 1
	
 50	continue

	zmax = vlow + (max * vwidth) - (vwidth / 2.0)

	if (debug) write (6,*) 'histo pass ',jit,m,zmax


cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

	if (m.lt.3) then
		z84 = -999.
                z50 = -999.
                z16 = -999.
                return
        endif


c 84% quartile

	i84 = nint( 0.84 * m * 1. )
        isum = 0
        do j=1,max

                isum = isum + count(j)
                if (isum.eq.i84) then
                        z84 = vlow + (j * vwidth) - (vwidth / 2.0)
                        goto 53
                endif

                if (isum.gt.i84) then
c                 interpolate
                  idel = isum - isum_prev
                  ilow = i84 - isum_prev
                  ratio = (ilow*1.) / (idel*1.)
                  del = vwidth * ratio

                  z84 = (del + vlow) + ((j-1) * vwidth) - (vwidth / 2.0)
                  goto 53
                endif

                isum_prev = isum
        enddo
 53     i=1

	if (debug) write (6,*) 'hist 84% ',z84
	
c 50% (median) quartile

	i50 = nint( 0.50 * m * 1. )
        isum = 0
        do j=1,max

                isum = isum + count(j)
                if (isum.eq.i50) then
                        z50 = vlow + (j * vwidth) - (vwidth / 2.0)
                        goto 54
                endif

                if (isum.gt.i50) then
c                 interpolate

                  idel = isum - isum_prev
                  ilow = i50 - isum_prev
                  ratio = (ilow*1.) / (idel*1.)
                  del = vwidth * ratio

                  z50 = (del + vlow) + ((j-1) * vwidth) - (vwidth / 2.0)
                  goto 54
                endif

                isum_prev = isum
        enddo
 54     i=1

	if (debug) write (6,*) 'hist 50% ',z50

c 16%  quartile

        i16 = nint( 0.16 * m * 1. )
        isum = 0
        do j=1,max

                isum = isum + count(j)
                if (isum.eq.i16) then
                        z16 = vlow + (j * vwidth) - (vwidth / 2.0)
                        goto 55
                endif

                if (isum.gt.i16) then
c                 interpolate
                  idel = isum - isum_prev
                  ilow = i16 - isum_prev
                  ratio = (ilow*1.) / (idel*1.)
                  del = vwidth * ratio

                  z16 = (del + vlow) + ((j-1) * vwidth) - (vwidth / 2.0)
                  goto 55
                endif

                isum_prev = isum
        enddo
 55     i=1

	if (debug) write (6,*) 'hist 16% ',z16

	
c done with histogram; compute width == sigma

	hsig = (z84 - z16)/2.0

	if (debug ) write (6,*) Jit, z16, z50, z84, hsig

	 vlow  = z50 - (hsig * 3.)
         vhigh = z50 + (hsig * 3.)

 1000	continue

 1001	return

	end



	subroutine  maskbandy (nxx,nyy,nsx,nsy,grid,
     1     x0,y0,xc,yc,Zmask,null)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	real grid(nxx,nyy)
	integer*2 Zmask (nxx,nyy)

c	write (6,*) '*** masking channel 3/4 band effect ghosts'

	gfactor = 1.  

	ddx=0.
	ddy=0.
	Factor = 1.

        x1 = (xc+ddx) + (4.*gfactor)
        y1 = yc + ddy
        rad = 2.75*gfactor * Factor
        call mask_radial (nxx,nyy,nsx,nsy,
     1     grid,x1,y1,rad)
        x2 = (xc+ddx) + (8.*gfactor)
	y2 = yc+ddy
        rad = 2.5*gfactor * Factor
        call mask_radial (nxx,nyy,nsx,nsy,
     1     grid,x2,y2,rad)
        x3 = (xc+ddx) + (13.*gfactor)
        y3 = yc + ddy
        rad = 2.*gfactor * Factor
        call mask_radial (nxx,nyy,nsx,nsy,
     1     grid,x3,y3,rad)


c comment the following to remove bandwidth effects from final image
	do j=1,nsy
	do i=1,nsx
		if (grid(i,j).lt.-99.) then
			Zmask(i,j) = -1.
	                null = 1
		endif
	enddo
	enddo


	return
	end


	subroutine maskstars (nxx,nyy,nsx,nsy,grid,
     1    ns,xstars,ystars,rstars,x0,y0,xc,yc)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	real grid(nxx,nyy)
	real xstars (999),ystars(999),rstars(999)
	logical debug

	nact = 0
	gfactor = 1.    !  the images are not resampled

	do 812 j=1,ns
		dx = xstars (j) - x0
		dy = ystars (j) - y0

	if ((abs(dx).lt.5.).and.(abs(dy).lt.5.)) goto 812

		xx = xc + (dx*gfactor)
		if (xx.lt.1) goto 812
		if (xx.gt.nsx) goto 812

		yy = yc + (dy*gfactor)
		if (yy.lt.1) goto 812
                if (yy.gt.nsy) goto 812

		rad = rstars(j)*gfactor
		nact = nact + 1
		call mask_radial (nxx,nyy,nsx,nsy,
     1           grid,xx,yy,rad)
 812	continue


	return
	end
	

	
C *************************************************************************
	subroutine gridex (ii,jj,gfactor,nx,ny,idex,jdex,X,Y)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	integer nx,ny,idex,jdex,ii,jj
	real gfactor


	T = gfactor - 1.0
	idex = nint((ii + T)/gfactor)
	jdex = nint((jj + T)/gfactor)

	T = 1. / (gfactor * 2.)

	X = 0.5 + (ii * 1. / gfactor) - T
	Y = 0.5 + (jj * 1. / gfactor) - T

	return
	end





        SUBROUTINE mask_radial (nxx,nyy,nx,ny,
     1             array,x0,y0,rad)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        dimension array(nxx,nyy)

	blankval = -947.
	if (rad.le.0.) goto 47

        i0 = nint(x0)
        j0 = nint(y0)
	idel = nint(rad)

        il = i0 - idel
        ih = i0 + idel
        jl = j0 - idel
        jh = j0 + idel

        if (il.lt.1) il=1
        if (jl.lt.1) jl=1
        if (ih.gt.nx) ih=nx
        if (jh.gt.ny) jh=ny

        do j=jl,jh
                dy2 = (y0 - j)**2
        do i=il,ih
                dx2 = (x0 - i)**2
                dr = sqrt(dx2 + dy2)
                if (dr.le.rad) then
			array(i,j) = blankval
		endif

        enddo
        enddo

 47	i=1


        return
        end




	subroutine elphot (nx,ny,sarray,lmask,rmax,zmed,ssig,csig,xc,yc,rat,phimax,
     1               xmag,zerr,ntot,xint,zero,exptime,ncoadd,flag)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (pi=3.1415926536, gain = 5.0, rdnoise = 20.,
     1             rtrunc = 0.5, rtruncmax = 1800.)
	real  sarray(7001,7001)
	integer*2 lmask(7001,7001),imask,flag

	logical the_end,dobox

	dobox = .false.
	if (rmax.lt.rtrunc) rmax = rtrunc
	if (rmax.gt.rtruncmax) rmax=rtruncmax

	if (rat.eq.-1.) then
		rat = 1.0
		dobox = .true.
c		write (6,*) 'warning: doing box'
	endif
	the_end = .false.

	ntot = 0
	xint = 0.
	ztot = 0.0

        jstrt=yc-rmax-2
	jstrt = max(jstrt,1)
    	jend=yc+rmax+2
	jend=min(jend,7001)
    	istrt=xc-rmax-2
	istrt = max(istrt,1)
    	iend=xc+rmax+2
	iend=min(iend,7001)

c	write (6,*) 'centering here ',xc,yc

c	write (6,*) 'start ',istrt,iend,jstrt,jend
	do 100 j=jstrt,jend
	      	dy=(j*1.)-yc
	do 101 i=istrt,iend
		dx=(i*1.)-xc

                call w_ell (rat,phimax,dx,dy,dr)

		if (dobox) then
			if (abs(dx).gt.rmax) goto 101
			if (abs(dy).gt.rmax) goto 101
			dr = 0.0
		endif
		
			
		if ( (dr.ge.0.).and.(dr.le.rmax+1.20) ) then
c inside  ellipse !!!!

			if ((j.lt.1).or.(j.gt.ny)) then
				the_end=.true.
                                goto 100
                        endif

			if ((i.lt.1).or.(i.gt.nx)) then
				the_end=.true.
				goto 101
			endif


			del = abs(dr-rmax)
			if (del.le.1.25) then
                                !  check frac pixel
                                call fracpix (xc,yc,i,j,rmax,rat,
     1                  phimax,farea)
                        else
                                  farea = 1.0
                        endif

			z = sarray (i,j) - zmed  ! subtract the background
			imask = lmask (i,j)

	if (farea.gt.0) then
c		write (6,*) '**',i,j,dx,dy,dr,z,farea
	else
c		write (6,*) i,j,dx,dy,dr,z,farea
	endif

	
c	write (6,*) i,j,z,imask

			if (imask.gt.0) then
                                 if (imask.ne.3) then
                                        flag=imask
                                 else
                                        if (flag.eq.0) flag=imask
                                 endif
                        endif

		        if (z.gt.-50.) then
		       		xint = xint + (z*farea)   ! integrated flux
				ztot = ztot + farea       ! total area
		       		ntot=ntot+nint(farea)
			endif

		  endif

 101		continue
 100	  continue

	
c	write (6,*) 'elphot ',xint,ztot,ntot
	Atest = 3.14159 * (rmax**2)
c	write (6,*) ztot,nint(ztot),Atest,xint,zero
	

	  ntot = nint(ztot)
	  if(xint.le.0.) then
	      xmag = 0.
	      zerr = 0.
	      zerr2 = 0.

	      call patchit (xint,ntot,zero,csig,zmed,xmag,zerr,zerr2,ncoadd)
	  else
	    flux_per_sec = xint / exptime  ! time normalized flux
	    xmag=zero -(2.5*log10(flux_per_sec))
	    call photom_error (ntot,xint,zmed,zerr,csig,zerr2,ncoadd)

 200        format(f6.1,f7.2,f8.1,f7.3,i7,e12.5)

	   endif


c	theo = 3.1415927 * (rmax**2) * rat
c	write (6,*) 'caut:R,rat,phi,sum ',rmax,rat,phimax,ztot,theo,xmag

c	write (201,*) 'elphot results: npix,rmax,xmag,rat,phi',ntot,rmax,xmag,rat,phimax,IB
c	write (6,*) 'elphot results: npix,rmax,xmag,rat,phi',ntot,rmax,xmag,rat,phimax,IB


	return
	end

c  (x0,y0) = coordinates of source 
c  i,j = pixel of interest
c  R is target radius
c  rat & phimax the elliptical params
c  farea is fractional area of pixel

	subroutine fracpix (x0,y0,i,j,R,rat,phimax,farea)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	block = 9.0
	area = block**2
	nb = block
	MID = nint(block/2.0)

	nsum = 0
	do l=1,nb
		NDEL = L - MID
		Y = (NDEL / block) + j

		DY = Y - Y0
		DY2 = DY ** 2
	do k=1,nb
		NDEL = k - MID
                X = (NDEL / block) + i

		DX = X - X0

		if (rat.lt.0.99) then
			call w_ell (rat,phimax,dx,dy,dr)
		else
			DX2 = DX **2
			DR = sqrt (DX2+DY2)
		endif
	
		if (R.ge.DR) nsum=nsum+1

	enddo
	enddo

	farea = (nsum*1.0) / area

	return
	end


	subroutine photom_error (npix,sum,back,zerr,csig,zerr2,ncoadd)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	parameter (gain = 5.2, rdnoise = 10.)
	real back

	constant = npix / ((gain**2) * ncoadd)

c poisson term
c	t1 = sum / (ncoadd * gain)
c background poisson term
c	t2 = constant * back * gain
c	t2 = constant * back * gain / 4.0

c	t2 = (npix * back) / (gain * ncoadd)
c read-noise term
c	t3 = constant * ((rdnoise / 4.0)**2)
c	t3 = (rdnoise**2) * npix / (  (gain**2) * ncoadd * 4.0 )

ccc total noise

c	znoise = sqrt(t1 + t2 + t3)

c delta-magnitude
c	snr1 = sum / znoise
	
c	zerr = 1.0857  / snr1

c	zz = 19.94 - (2.5*log10(sum))

cccccccccccccccccccccc
c  the following method is the approved method; it uses
c  the measured coadd noise

c
	term1 = npix * 1. * (csig**2)
	term2 = sum / (ncoadd * gain)
	term3 = (npix*csig)**2  
        tnoise = sqrt (term1 + term2 + term3)
	snr2 = sum / tnoise

	zerr2 = sqrt ( (1.0857 / snr2)**2 )
	zerr = zerr2

ccccccccccccccccccccccccccccccccc

c	term1 = (conweight(1)*snr1)**2
c	term2 = (conweight(2)*snr2)**2
c	wt = (conweight(2)**2)+(conweight(1)**2)
c	snrt2 = (term1+term2)/wt
c	snrt = sqrt (snrt2)

c	snrt = (conweight(1)*snr1) + (conweight(2)*snr2)

c	zerr = 1.0857  / snrt
c	zerr2 = zerr


c	write (6,*) 'PHOTERR ',conweight(1),conweight(2),' snrs: ',snr1,snr2,snrt,zerr

	return
	end
	
c  old method (defunct)
c		term1 = npix * 4. * (csig**2)
c		term2 = sum / (ncoadd * gain)
c		tnoise = sqrt (term1 + term2)
c		kerr = 1.0857 * tnoise / sum




	subroutine patchit (sum,npix,zero,csig,back,zmag,zerr,zerr2,ncoadd)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)


cccccccc
c  compute mag of negative flux
	if (sum.eq.0.) sum = -0.001

	zmag = 99.0 - (zero - (2.5*log10(abs(sum)) ) )

cccccccccccccccc
c estimate uncertainty

	call photom_error (npix,abs(sum),back,zerr,csig,zerr2,ncoadd)
	if (zerr.gt.9.9) zerr=9.9
	if (zerr2.gt.9.9) zerr2=9.9

	return
	end

        subroutine w_ell (e,phimax,dx,dy,a)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

        parameter (pi = 3.14159265)

        d=-phimax*pi/180.
        r2 = (dx**2) + (dy**2)

        if(dx.ne.0) then
          t=atan(dy/dx)
        else
          t=pi/2.
        endif

        ct = cos(t)
        st = sin(t)
        cd = cos(d)
        sd = sin(d)

        c1= (((e * ct)**2 ) + (st**2) ) * (cd**2)
        c2 = (1. - (e**2)) * 2. * st * ct * sd * cd
        c3 = (((e * st)**2 ) + (ct**2) ) * (sd**2)

        a2 = (r2 / (e**2)) * (c1 + c2 + c3)
        a = sqrt(a2)

        return
        end



	subroutine readFhead(fname,Hdr)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

C  Print out all the header keywords in all extensions of a FITS file

	character*(*) fname,Hdr
      integer status,unit,readwrite,blocksize,nkeys,nspace,hdutype,i,j
      integer L,numchar,nl,nh
      character record*80


C  The STATUS parameter must always be initialized.
      status=0
C     open the FITS file, with read-only access.  The returned BLOCKSIZE
C     parameter is obsolete and should be ignored.

	call ftgiou(unit,status)

	L = numchar(fname)
c	write (6,'(a)') ' '
c	write (6,'(a)') fname(1:L)

	status = 0
      readwrite=0
      call ftopen(unit,fname(1:L),readwrite,blocksize,status)

	if (status.ne.0) then
		write (6,*) 'problem reading header ',status
		write (6,'(a)') fname(1:L)
	endif


cwrite (6,*) status

C  The FTGHSP subroutine returns the number of existing keywords in the
C  current header data unit (CHDU), not counting the required END keyword,
      call ftghsp(unit,nkeys,nspace,status)

c	write (6,*) status,nkeys
	Hdr = ''

C  Read each 80-character keyword record, and print it out.
	nl = 1
      do i = 1, nkeys
          call ftgrec(unit,i,record,status)
c         write (6,'(a)') record

	  nh = nl + 79
	  Hdr (nl:nh) = record
	  nl = nh + 1

      end do

 	call ftclos(unit, status)
        call ftfiou(unit, status)


	return
	end




	subroutine gconvol (nxx,nyy,nx,ny,array,sarray,sigma)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	real array(nxx,nyy),sarray(nxx,nyy)
	integer Rmax

	zmin = -99.

	Rmax = nint(sigma*5.0)
	area = 3.14159 * (Rmax**2)
	nmin = nint(area * 0.1)

c convolve image with gauss function
c     F/F0 = exp (-Z**2 / 2); where Z = X / sigma

	ntot = 0
	neff = 0
	do 101 j = 1,ny
	do 100 i = 1,nx

		sarray(i,j) = array(i,j)
c		if (array(i,j).le.0.) goto 100

		il = i - Rmax
		jl = j - Rmax
		ih = i + Rmax
		jh = j + Rmax

c integrate kernal*array

		gsum = 0.
		sum = 0.
		nsum = 0

		sum_special = 0.

		do 51 jj=jl,jh
			if (jj.lt.1) goto 51
			if (jj.gt.ny) goto 51

			dy = (jj - j)*1.
		do 50 ii=il,ih

			if (ii.lt.1) goto 50
                        if (ii.gt.nx) goto 50
			V = array(ii,jj)
			if (V.le.zmin) goto 50

			dx = (ii - i)*1.
			dr = sqrt((dx**2)+(dy**2))	
			idr = nint(dr)
			if (idr.gt.Rmax) goto 50
		
			G = gkern (dr,sigma)

			sum = sum + (G * V)
			gsum = gsum + G
			nsum=nsum+1

 50		continue
 51		continue


		if (nsum.gt.0) ntot=ntot+1

		if ((gsum.le.0.).or.(sum.eq.0.)) then
			sarray(i,j) = 0.
                        goto 100
		endif	

		if (nsum.lt.nmin) goto 100

		sarray(i,j) = sum / gsum

 100	continue
 101	continue


	return
	end


ccccccccccccccc
c modified exponential
c
c    F/F0 = exp (-Z**2 / 2); where Z = X / sigma

        function  gkern (r,sigma)

	implicit integer (i-n)
        implicit real*4 (a-h)
        implicit real*4 (o-z)

	
	term1 = r / sigma
	
	C = (term1 ** 2) / 2.0

        gkern = exp(-C) 

	return
	end

