#!/usr/bin/env python

#  python-interactive IRAC/MIPS BCD saturation recovery
#  T. Jarrett
#  Version:  April 2, 2009

import math, string, sys, os
import numpy
import pysao
import pyfits
import os.path
import scipy.io as io
import pylab 

from matplotlib import rc
from matplotlib.font_manager import FontProperties
from matplotlib.ticker import MultipleLocator, FixedLocator, FormatStrFormatter, FuncFormatter


lim = 'scale limits -0.1 1'


def fitskeyval(hdr,key):

  for line in hdr:
     if line == key:
	sval = hdr[key]
	return sval
  else:
	sval = "null"
	return sval


def getstretch():
	S = str(raw_input('Enter new stretch: '))
	lim = 'scale limits ' +  S
	return lim

def dodisp(lim,im,fr):
  S = 'file ' + im
  Sfr = 'frame ' + fr

  ds9.set('zoom to fit')
  ds9.set(Sfr)
  ds9.set(lim)
  ds9.set(S)


def dobox (R,x,y):
  size = R * 2.
  width = str(size)
  height = str(size)

  S = "image; box " + x + " " + y + " " + width + " " + height + " 0 # color = green"
  print S
  ds9.set('regions',S)


def docircle (R,x,y):
  print R
  S = "image; circle " + x + " " + y + " " + str(R) + " # color = magenta"
  print S
  ds9.set('regions',S)


def markit(x,y,radius,fr):
  Sfr = 'frame ' + fr
  ds9.set(Sfr)
  S = "image; circle " + x + ' ' + y + ' ' + radius + "# color = blue"
  ds9.set('regions',S)


##########
Rforce = "0.0"
tweakx = " "
tweaky = " "
dopuff = "nopuff"


argc = len(sys.argv)

if argc < 3:
  print "** usage: **"
  print " "
  print "python BCDsaturation.py <image name> <BCDsaturation.par>"
  print " "
  print "example: "
  print "python BCDsaturation.py SPITZER_I3_3650816_0041_0000_4_bcd.fits BCDsaturation.par"
  sys.exit()

ds9 = pysao.ds9()

image = sys.argv[1]

check =  os.path.isfile(image)

if (check):
 print image
else:
 image = image + '.fits'
 check =  os.path.isfile(image)
 if (not check):
   print "** error -- image does not exist: ",image
   sys.exit()


imbase=image.rstrip('.fits')
SATim = imbase + '_SatFixed.fits'
SATcheck =  os.path.isfile(SATim)
if (SATcheck):
  command = ('rm -f ' + SATim)
  os.system(command)
Didit = False
Special = False

twomass = False

fits_header = pyfits.getheader(image)
INS = fitskeyval(fits_header,'INSTRUME')
if INS == "IRAC":
  pscale = 1.22  # assume BCD scale 
elif INS == "MIPS":
  pscale = 2.45  # assume BCD scale 
#  print "there"
  #  check the channel
  CHN = int(fits_header['CHNLNUM'])
  if CHN == 2:
	#  MIPS 70um
	INS = "MIPS70"
	pscale = 9.86
	CDELT2 = fitskeyval(fits_header,'CDELT2')
	if CDELT2 != 'null':
		pscale = abs(3600. * float(CDELT2))
else:
  pscale = 1.22  # assume BCD scale 

#check to see if 2MASS coadd image
TINS = fitskeyval(fits_header,'FILTER')
if TINS == "k":
   print "2MASS K-band image"
   CHN = 3
   twomass = True
   INS = TINS
elif TINS == "h":
   print "2MASS H-band image"
   twomass = True
   CHN = 2
   INS = TINS
elif TINS == "j":
   print "2MASS J-band image"
   CHN = 1
   twomass = True
   INS = TINS
if twomass:
   CDELT2 = fitskeyval(fits_header,'CDELT2')
   if CDELT2 != 'null':
     pscale = abs(3600. * float(CDELT2))


print "approximate pscale = ",pscale


ds9.set('scale ZScale')
ds9.set('file ' + image)
ds9.set('zoom to fit')

foo = ds9.get('scale limits')
lim = 'scale limits ' + foo

#lim = ""

Pon = False


### read the parameter file

parfile = sys.argv[2]

check =  os.path.isfile(parfile)

if (check):
 print parfile
else:
 print "** error -- parameter file does not exist: ",parfile
 sys.exit()

dat = file(parfile,'r')       
it = dat.readlines()

for line in it:

	col=line.split()
	i = len(col)

	if i > 1: 
	  if col[0] != '#':
             if col[0] == 'fpth':
                binary = col[1]
             if col[0] == 'Rphot_1':
		Rphot_1 = col[1]
             if col[0] == 'Rphot_2':
                Rphot_2 = col[1]
	     if col[0] == 'Rextract':
		Rextract = col[1]

dat.close()


if INS == "IRAC":
  Rphot = Rphot_1
elif (INS == "MIPS" or INS == "MIPS70"):
  Rphot = Rphot_2
else:
  Rphot = Rphot_1

Rphot = float (Rphot)  / pscale   #  pixel units
Rtest = Rphot * 2. * pscale

if float (Rextract) < Rtest:
	Rextract = str (Rtest)

stars = "stars.tmp"
check =  os.path.isfile(stars)

if (check):
  command = ('rm -f ' + stars)
  os.system(command)




text = '''**********************************************************
Please select one of the following options.
1. redisplay images (or just press enter) with zoom to fit
2. change the stretch
3. choose source to recover
4. mark stars to mask
5. process
6. modify the replacement radius
7. tweak the centering coordinates
8. puff out the PSF w/ gaussian convolution
9. choose another star to recover
10. to quit
'''

counter = 1

#this while loop runs the menu and options
while True:

 counter += 1
 option = ""

 if counter > 1:
   option = str(raw_input(text))


 if option == "":
  option = "1"


 if option == '1':

  ds9.set('file ' + image)
  ds9.set('zoom to fit')
  os.system('clear')

 if option == '2' or option == 'r':

  print lim
  lim = getstretch()
  dodisp(lim,image,"1")
  os.system('clear')

 if option == '3' or option == 'p':

   Pon = True

   print 'pick on source center position'
   crd = ds9.get('imexam coordinate image')
   C = crd.split()
   x0 = float(C[0])
   y0 = float(C[1])
   ix = int(round(x0))
   jy = int(round(y0))
   print 'x,y = ',ix,jy

   S = "pan to " + C[0] + " " + C[1]
   ds9.set(S)
   if INS == "MIPS70":
	ds9.set('zoom to fit')
   else:
        ds9.set('zoom 3')

   Rsize = float(Rextract) / pscale   # pixels
   dobox (Rsize, C[0], C[1])
   docircle (Rphot, C[0], C[1])


 if option == '4' or option == 's'  or option ==  'm':

   print 'pick ons star'
   crd = ds9.get('imexam coordinate image')
   C = crd.split()
   xs = float(C[0])
   ys = float(C[1])
   ix = int(round(xs))
   jy = int(round(ys))
   print 'x,y = ',ix,jy

   print 'now mark the radius'
   crd = ds9.get('imexam coordinate image')
   C = crd.split()
   xr = float(C[0])
   yr = float(C[1])

   dr =  ( (xr-xs)**2 + (yr-ys)**2 )**0.5

   C[0] = str(xs)
   C[1] = str(ys)
   srad = str(dr)

   markit(C[0],C[1],srad,"1")

   Sline = ' %.1f  %.1f %.1f\n'%(xs,ys,dr)

   fileS = open(stars, 'a')
   fileS.write(Sline)
   fileS.close()


 if Pon and (option == '5' or option == '6' or option == '7'):

  Rep = ""
  if option == '6':
     Rep = str(raw_input('enter new replacement radius '))
     Rforce = Rep

  if option == '7':
     tweakx = str(raw_input('enter X displacement (pixel units)'))
     tweaky = str(raw_input('enter Y displacement (pixel units)'))


  Runimage = image
  if Special:
    Runimage = SATim

   #  run binary
  command = (binary + " "  + Runimage + " " + str(x0) + " " + str(y0) + " " + parfile + " " + stars + " " +  INS + " " + Rforce +  " " + dopuff +  " " + tweakx +  " " + tweaky)
  print binary + " "  + Runimage + " " + str(x0) + " " + str(y0)  + " " + parfile + " " + stars + " " + INS + " " + Rforce +  " " + dopuff +  " " + tweakx +  " " + tweaky

  
  os.system(command)

  SATcheck =  os.path.isfile(SATim)
  if (SATcheck):
    Didit = True


  ds10 = pysao.ds9()

  ds10.set('tile yes')
  ds10.set('tile grid')
  ds10.set('scale ZScale')

  S = 'file ext.fits'
  Sfr = 'frame 1'
  ds10.set(Sfr)
  ds10.set(lim)
  ds10.set(S)
  ds10.set('regions', "image; text 15 5 # text={source} color=white font={times 18 bold}")
  ds10.set('zoom to fit')

  S = 'file model.fits'
  Sfr = 'frame 2'
  ds10.set(Sfr)
  ds10.set(lim)
  ds10.set(S)
  ds10.set('regions', "image; text 19 2 # text={PSF model} color=white font={times 18 bold}")
  ds10.set('zoom to fit')

  S = 'file res.fits'
  slim = 'scale limits 0 2'
  Sfr = 'frame 3'
  ds10.set(Sfr)
  ds10.set(slim)
  ds10.set(S)
  ds10.set('regions', "image; text 19 2 # text={residual} color=white font={times 18 bold}")
  ds10.set('zoom to fit')

  S = 'file rectify.fits'
  Sfr = 'frame 4'
  ds10.set(Sfr)
  ds10.set(lim)
  ds10.set(S)
  ds10.set('regions', "image; text 19 2 # text={rectified source} color=white font={times 18 bold}")
  ds10.set('zoom to fit')

  Sfr = 'frame 1'
  ds10.set(Sfr)

  ds10.set('zoom to fit')
  ds10.set('match frames image')
  ds10.set('zoom to fit')


# load the profile

  dat = file('wip.com','r')
  line = dat.readline()
  C=line.split()
  base = C[0]

  ds10.set('saveimage png ' + base + '.png')
  print base + '.png'

  line = dat.readline()
  C=line.split()
  rlow = float(C[0])
  rhigh = float(C[1])
  SBlow = float(C[2])
  SBhigh = float(C[3])

#  print rlow," ",rhigh," ",SBlow," ",SBhigh

  line = dat.readline()
  C=line.split()
  Replace = float(C[0])

#  print Replace 

  line = dat.readline()
  C=line.split()
  Rlbest = float(C[0])
  Ratratio = float(C[1])
 
#  print Rlbest," ",Ratratio

  line = dat.readline()
  C=line.split()
  Rhbest = float(C[0])

  line = dat.readline()
  C=line.split()
  Ratlow = float(C[1])

  line = dat.readline()

  line = dat.readline()
  C=line.split()
  Rathigh = float(C[1])

#  print Rhbest," ",Ratlow," ",Rathigh

  dat.close()


# plot limits

  ax=pylab.axes()
#  rc('text', usetex=True)


  check =  os.path.isfile('fort.66')
  if (check):

   SB = numpy.loadtxt('fort.66')
   X = SB[:,0]
   E = SB[:,3]
   Y = SB[:,4]

   pylab.errorbar (X,Y,yerr=E,xerr=None, ecolor='black')
   plot = pylab.plot(X,Y,'k')

  
   SBp = numpy.loadtxt('fort.45')
   X = SBp[:,0]
   Y = SBp[:,1]

   pylab.plot(X,Y,'k.',markersize=4)

#   pylab.plot([0,999],[Logsig,Logsig],'r--')
   pylab.plot([Replace, Replace],[0.15,99],'m--')
   pylab.plot([rlow,rhigh],[Ratratio,Ratratio],'b--')
   pylab.plot([Rlbest,Rhbest],[Ratlow,Ratlow],'r--')
   pylab.plot([Rlbest,Rhbest],[Rathigh,Rathigh],'r--')

   rval = float(Replace) - 0.
   pylab.text(rval,0.05,'replacement radius',horizontalalignment='center',fontsize=12, color='m')


   ax.set_xlim(rlow, rhigh)
   ax.set_ylim(SBlow, SBhigh)

   pylab.xlabel('radius (BCD units)',fontsize=14)
   pylab.ylabel('star to PSF ratio',fontsize=14)
   T = str(base) 
   pylab.title(T,fontsize=14)
  
   print base + '.SB.plot.png'
   print base + '.tbl'

#  time.sleep (1)
   T = base + '.SB.plot.png'
   pylab.savefig(T,orientation='landscape')

   pylab.show()

#  pylab.close() 

# clean up

  if os.path.isfile("fort.17"):
     command = ('rm -f fort.17')
     os.system(command)

  if os.path.isfile("fort.45"):
     command = ('rm -f fort.45')
     os.system(command)

  if os.path.isfile("fort.66"):
     command = ('rm -f fort.66')
     os.system(command)

  T = 'ext.fits'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'model.fits'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'check.fits'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'res.fits'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'rectify.fits'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'wip.com'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

  T = 'stars.tmp'
  if os.path.isfile(T):
     command = ('rm -f ' + T)
     os.system(command)

 if option == '8':
   dopuff = "puff"
   print "guassian convolution mode on"

 if option == '9' and Didit:

   Rforce = "0.0"
   tweakx = " "
   tweaky = " "
   dopuff = "nopuff"


   dodisp(lim,image,"1")
   os.system('clear')

   print 'pick on source center position'
   crd = ds9.get('imexam coordinate image')
   C = crd.split()
   x0 = float(C[0])
   y0 = float(C[1])
   ix = int(round(x0))
   jy = int(round(y0))
   print 'x,y = ',ix,jy

   S = "pan to " + C[0] + " " + C[1]
   ds9.set(S)
   ds9.set('zoom 3')

   Rsize = float(Rextract) / pscale   # pixels
   dobox (Rsize, C[0], C[1])
   docircle (Rphot, C[0], C[1])

   Special = True

 if option == '10' or option ==  'q':
   print 'bye...'
   break

